#!/usr/bin/env python
import BaseClass

class Rulesets(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
		self.columns = "RULENAME"
		self.table = "TRE_RULESET"
		
		self.setSelectStatement()
		self.selectStatement += " WHERE ENABLED=1"
	
	def checkExistence(self, data):
		ruleName = data[0]
		self.cursor.execute("SELECT RULESETID FROM TRE_RULESET WHERE RULENAME='%s'" % ruleName)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT MAX(RULESETID) FROM TRE_RULESET")
		try:
			return self.cursor.fetchall()[0][0] + 1
		except:
			return 1
	
	def insert(self, id_, data):
		self.enable(data)
		return False
	
		try:
			statement = ""
			print statement 
			self.cursor.execute(statement)
			
			self.commit()
		except Exception, e:
			print e
			self.rollback()
			
	def enable(self, data):
		ruleName = data[0]
		try:
			statement = "UPDATE TRE_RULESET SET ENABLED=1 WHERE RULENAME='%s'" % ruleName
			print statement
			self.cursor.execute(statement)
			
			self.commit()
		except:
			self.rollback()
		
	def importFromFile(self, tdf):
		"""
		tdf=Tab Delimited File
		First line, which has the header for the columns, is ignored.
		"""
		lines = file(tdf, "r").readlines()[1 : ]
		for line in lines:
			fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
			fields = map(lambda s : ["", s][s != "null"], fields)
			self.enable(tuple(fields))		
		

def main():
	rs = Rulesets()
	rs.export("/tmp/rulesets.tdf")
	
if __name__ == "__main__":
	main()