#!/usr/bin/env python
import BaseClass
import ProcessDefinitions

class SelectorKeys(BaseClass.BaseClass):
	
	#		(0,	1,		   2,		 3,		)
	# data = (NAME, PARTNERTYPE, CONTEXTID, PROVIDERID)
	
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "SELECTIONKEY, PROCESSDEFINITIONID"
		self.table = "TTV_SELECTOR"
		#self.setSelectStatement()
		self.selectStatement = "SELECT S.SELECTIONKEY, PD.NAME_ "\
								"FROM TTV_SELECTOR S "\
								"JOIN JBPM_PROCESSDEFINITION PD "\
								"ON (S.PROCESSDEFINITIONID = PD.ID_)"


	def checkExistence(self, data):
		key = data[0]
		self.cursor.execute("SELECT * FROM TTV_SELECTOR WHERE SELECTIONKEY='%s'" % key)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			processDefinitionId = ProcessDefinitions.ProcessDefinitions().checkExistence(tuple([data[1]]))
			statement = "INSERT INTO TTV_SELECTOR (SELECTIONKEY, PROCESSDEFINITIONID) VALUES %s" % str(tuple([data[0], processDefinitionId]))
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

def main():
	sk = SelectorKeys()
	#sk.add("120112", "Content Processing Template")
	sk.export("/tmp/selectorkeys.tdf")
	
if __name__ == "__main__":
	main()