#!/usr/bin/env python
import BaseClass
import Sites

class SiteParameters(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "SITE_NAME, NAME, VALUE"
		self.table = "SITES_DIST_CONF_PARAMS"
		self.selectStatement = "SELECT S.NAME SITE_NAME, P.NAME, P.VALUE "\
			"FROM SITES_DIST_CONF_PARAMS P "\
			"JOIN SITES_SITE S "\
			"ON (P.SITEID = S.ID_)"	
  	
	def checkExistence(self, data):
		self.siteId = Sites.Sites().checkExistence(data[0])
		name = data[1]
		self.cursor.execute("SELECT VALUE FROM SITES_DIST_CONF_PARAMS WHERE SITEID='%s' AND NAME='%s'" % (self.siteId, name))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO SITES_DIST_CONF_PARAMS (SITEID, NAME, VALUE) VALUES %s" % str(tuple([self.siteId] + list(data[1:])))
			print statement 
			self.cursor.execute(statement)
			
			self.commit()
		except Exception, e:
			print e
			self.rollback()
	

def main():
	s = SiteParameters()
	
	s.export("/tmp/siteparameters.tdf")
	
if __name__ == "__main__":
	main()