#!/usr/bin/env python
import BaseClass
import Partners

class SiteTimedDistribution(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "RULETYPEID, STARTDATE, CREATEDATE "
        self.table = "SCH_RULE, SCH_RULEPARAMETER, SCH_JOB"
        self.setSelectStatement()    
        self.selectStatement = "SELECT r.RULETYPEID,r.STARTDATE , r.CREATEDATE "\
            "FROM SCH_RULE r "\
            "JOIN SCH_JOB sj "\
            "ON sj.RULEID=r.ID_ "\
            "AND sj.ASSOCIATED_ENTITY_TYPE='sitetimer' "
            
    def checkExistence(self, data):
        self.cursor.execute("SELECT * FROM SCH_RULE WHERE RULETYPEID=%s AND STARTDATE=timestamp'%s'" % (data[0],data[1]))
        rowsRule = self.cursor.fetchall()
        
        if len(rowsRule):
            return rowsRule[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self, id_, data):
        try:
            ruleTypeID=data[0]
            ruleStartDate=data[1]
            statement = "INSERT INTO SCH_RULE (RULETYPEID,STARTDATE,CREATEDATE) VALUES ( %s , timestamp'%s', timestamp'%s' ) " % (ruleTypeID,ruleStartDate,data[2])
            print statement 
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
def main():
    s = SiteTimedDistribution()    
    s.export("/tmp/SiteTimedDistribution.tdf")
    
if __name__ == "__main__":
    main()