#!/usr/bin/env python
import BaseClass
import Partners

class SiteTimedDistributionAssociatedEntities(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "JOB, ENTITY"
        self.table = "SCH_JOB, SITES_SITE"
        self.setSelectStatement()    
        self.selectStatement = "SELECT sj.NAME AS JOB, ss.NAME AS ENTITY "\
            "FROM SCH_JOB sj, SITES_SITE ss, SCH_ASSOCIATED_ENTITIES ae "\
            "WHERE sj.ID = ae.JOB_ID "\
            "AND ss.ID_ = ae.ENTITY_ID "\
            "AND sj.ASSOCIATED_ENTITY_TYPE='sitetimer' "
            
    def checkExistence(self, data):
        siteJob = data[0]
        self.cursor.execute("SELECT ID FROM SCH_JOB WHERE NAME='%s'" % siteJob)
        rowsJob = self.cursor.fetchall()

        siteEntity = data[1]
        self.cursor.execute("SELECT ID_ FROM SITES_SITE WHERE NAME='%s'" % siteEntity)
        rowsEntity = self.cursor.fetchall()
 
        self.cursor.execute("SELECT * FROM SCH_ASSOCIATED_ENTITIES WHERE JOB_ID=%s and ENTITY_ID=%s" % (rowsJob[0][0],rowsEntity[0][0]))
        rows = self.cursor.fetchall()

        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self, id_, data):
        try:
            job = "SELECT ID FROM SCH_JOB WHERE NAME = '%s'" % str(data[0])
            self.cursor.execute(job)
            rowsJob = self.cursor.fetchall()
            
            entity = "SELECT ID_ FROM SITES_SITE WHERE NAME = '%s'" % str(data[1])
            self.cursor.execute(entity)
            rowsEntity = self.cursor.fetchall()
           
            statement = "INSERT INTO SCH_ASSOCIATED_ENTITIES (JOB_ID,ENTITY_ID) VALUES ( %s , %s ) " % (rowsJob[0][0],rowsEntity[0][0])
            print statement 
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
def main():
    s = SiteTimedDistributionAssociatedEntities()    
    s.export("/tmp/SiteTimedDistributionAssociatedEntities.tdf")
    
if __name__ == "__main__":
    main()