#!/usr/bin/env python
import BaseClass
import Partners

class SiteTimedDistributionRuleParameters(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "RULE_CREATEDATE, VALUE, ORDER_, RULE_PARAMETER_CREATEDATE  "
        self.table = " SCH_RULEPARAMETER, SCH_JOB"
        self.setSelectStatement()    
        self.selectStatement = "SELECT r.CREATEDATE,  rp.VALUE, rp.ORDER_, rp.CREATEDATE "\
            "FROM SCH_RULEPARAMETER rp "\
            "JOIN SCH_RULE r "\
            "ON r.ID_=rp.RULEID "\
            "JOIN SCH_JOB sj "\
            "ON sj.RULEID=rp.ruleid "\
            "AND sj.ASSOCIATED_ENTITY_TYPE='sitetimer' "\
            
    def checkExistence(self, data):
        ruleID = "SELECT ID_ FROM SCH_RULE WHERE CREATEDATE=timestamp'%s'" % (data[0])
        self.cursor.execute(ruleID)
        rowsRuleID = self.cursor.fetchall()

        self.cursor.execute("SELECT * FROM SCH_RULEPARAMETER WHERE RULEID=%s AND VALUE='%s' AND ORDER_=%s" % (rowsRuleID[0][0],data[1],data[2]))
        rowsRule = self.cursor.fetchall()

        if len(rowsRule):
            return rowsRule[0][0]
        else:
            return False
        
    def getNextId(self):
        self.cursor.execute("SELECT WFS.SCH_RULEPARAMETER_SEQ.NEXTVAL FROM DUAL")
        return self.cursor.fetchall()[0][0]
    
    def insert(self, id_, data):
        try:
            ruleID = "SELECT ID_ FROM SCH_RULE WHERE CREATEDATE=timestamp'%s'" % (data[0])
            self.cursor.execute(ruleID)
            rowsRuleID = self.cursor.fetchall()
            statement = "INSERT INTO SCH_RULEPARAMETER (RULEID,VALUE,ORDER_,CREATEDATE) VALUES ( %s , '%s', %s,timestamp'%s' ) " % (rowsRuleID[0][0],data[1],data[2],data[3])
            print statement 
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
def main():
    s = SiteTimedDistributionRuleParameters()    
    s.export("/tmp/SiteTimedDistributionRuleParameters.tdf")
    
if __name__ == "__main__":
    main()