#!/usr/bin/env python
import BaseClass
import Partners

class SiteTimerQrtzJob(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "JOB_NAME, JOB_GROUP, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY "
        self.table = "SCH_JOB, QRTZ_JOB_DETAILS"
        self.setSelectStatement()    
        self.selectStatement = "SELECT sj.NAME,qj.JOB_GROUP,qj.JOB_CLASS_NAME,qj.IS_DURABLE,qj.IS_VOLATILE,qj.IS_STATEFUL,qj.REQUESTS_RECOVERY "\
            "FROM QRTZ_JOB_DETAILS qj "\
            "JOIN SCH_JOB sj "\
            "ON qj.JOB_NAME=sj.ID "\
            "AND sj.ASSOCIATED_ENTITY_TYPE='sitetimer'"
            
    def checkExistence(self, data):
        jobName = data[0]
        self.cursor.execute("SELECT ID FROM SCH_JOB WHERE NAME='%s'" % jobName)
        rowsJob = self.cursor.fetchall()
        
        self.cursor.execute("SELECT * FROM QRTZ_JOB_DETAILS WHERE JOB_NAME='%s'" % (rowsJob[0][0]))
        rows = self.cursor.fetchall()
        
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self, id_, data):
        try:
            jobName = data[0]
            self.cursor.execute("SELECT ID FROM SCH_JOB WHERE NAME='%s'" % jobName)
            rowsJobId = self.cursor.fetchall()
            
            statement = "INSERT INTO QRTZ_JOB_DETAILS (JOB_NAME,JOB_GROUP,JOB_CLASS_NAME,IS_DURABLE,IS_VOLATILE,IS_STATEFUL,REQUESTS_RECOVERY) VALUES ( '%s','%s','%s','%s','%s','%s','%s' ) " % (rowsJobId[0][0],data[1],data[2],data[3],data[4],data[5],data[6])
            print statement 
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
def main():
    s = SiteTimerQrtzJob()    
    s.export("/tmp/SiteTimerQrtzJob.tdf")
    
if __name__ == "__main__":
    main()