#!/usr/bin/env python
import BaseClass
import Partners

class SiteTimerQrtzTriggers(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, MISFIRE_INSTR, SIMPLE_TRIGGER_REPEAT_COUNT, SIMPLE_TRIGGER_REPEAT_INTERVAL, SIMPLE_TRIGGER_TIMES_TRIGGERED,TRIGGER_LISTENER "
        self.table = "SCH_JOB, QRTZ_TRIGGERS"
        self.setSelectStatement()    
        self.selectStatement = "SELECT qt.TRIGGER_GROUP,sj.NAME,qt.JOB_GROUP,qt.IS_VOLATILE,qt.NEXT_FIRE_TIME,qt.PREV_FIRE_TIME,qt.PRIORITY,qt.TRIGGER_STATE,qt.TRIGGER_TYPE,qt.START_TIME,qt.MISFIRE_INSTR,qst.REPEAT_COUNT, qst.REPEAT_INTERVAL, qst.TIMES_TRIGGERED, qtl.TRIGGER_LISTENER "\
            "FROM QRTZ_TRIGGERS qt "\
            "JOIN SCH_JOB sj "\
            "ON qt.JOB_NAME=sj.ID "\
            "AND sj.ASSOCIATED_ENTITY_TYPE='sitetimer'"\
            "JOIN QRTZ_SIMPLE_TRIGGERS qst "\
            "ON qst.TRIGGER_NAME=qt.TRIGGER_NAME "\
            "JOIN QRTZ_TRIGGER_LISTENERS qtl "\
            "ON qtl.TRIGGER_NAME=qt.TRIGGER_NAME"
            
    def checkExistence(self, data):
        jobName = data[1]
        self.cursor.execute("SELECT ID FROM SCH_JOB WHERE NAME='%s'" % jobName)
        rowsJob = self.cursor.fetchall()
        
        self.cursor.execute("SELECT * FROM QRTZ_TRIGGERS WHERE JOB_NAME='%s'" % (rowsJob[0][0]))
        
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self, id_, data):
        try:
            jobName = data[1]
            self.cursor.execute("SELECT ID FROM SCH_JOB WHERE NAME='%s'" % jobName)
            rowsJobId = self.cursor.fetchall()

            stringNameConstant="TRIGGER"
            triggerName = "%s_%d" % (stringNameConstant,rowsJobId[0][0])

            
            statement = "INSERT INTO QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP, JOB_NAME,JOB_GROUP,IS_VOLATILE,NEXT_FIRE_TIME,PREV_FIRE_TIME,PRIORITY,TRIGGER_STATE,TRIGGER_TYPE,START_TIME,MISFIRE_INSTR) VALUES ( '%s','%s', '%s','%s', '%s', %s,%s,%s,'%s','%s', %s, %s ) " % (triggerName,data[0],rowsJobId[0][0],data[2],data[3],data[4],data[5],data[6],data[7],data[8],data[9],data[10])
            self.cursor.execute(statement)
            
            statement = "INSERT INTO QRTZ_SIMPLE_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED) VALUES ( '%s','%s', %s, %s, %s) " % (triggerName,data[0], data[11],data[12],data[13])
            self.cursor.execute(statement)
            
            statement = "INSERT INTO QRTZ_TRIGGER_LISTENERS (TRIGGER_NAME,TRIGGER_GROUP, TRIGGER_LISTENER) VALUES ( '%s','%s', '%s') " % (triggerName,data[0], data[14])
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
def main():
    s = SiteTimerQrtzTriggers()    
    s.export("/tmp/SiteTimerQrtzTriggers.tdf")
    
if __name__ == "__main__":
    main()