#!/usr/bin/env python
import BaseClass
import Partners

class Sites(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, FILE_LOOKUP_KEYS, "\
			"DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE"
		self.table = "SITES_SITE"
		self.setSelectStatement()	
		self.selectStatement = "SELECT NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, FILE_LOOKUP_KEYS, "\
			"DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE "\
			"FROM SITES_SITE "
			
	def checkExistence(self, data):
		siteName = data[0]
		self.cursor.execute("SELECT ID_ FROM SITES_SITE WHERE NAME='%s'" % siteName)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT WFS.SITES_SITE_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO SITES_SITE (ID_, NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, "\
				"FILE_LOOKUP_KEYS, DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE) VALUES %s" % str(tuple([id_] + list(data)))
			print statement 
			self.cursor.execute(statement)
			
			p = Partners.Partners()
			if p.add("SITE_%s" % id_, 1, "", ""):
				self.commit()
			else:
				self.rollback()
		except Exception, e:
			print e
			self.rollback()
	
#	def _export(self):
#		statement = "SELECT ID_, NAME, EXTERNALID, ACTIVE, DISTRIBUTION_OPTION, METADATA_FORMAT, FILE_LOOKUP_KEYS, "\
#			"DIST_TEMPLATE_NAME, ALERT_DELAY_PERIOD, TYPE FROM SITES_SITE"
#		print statement
#		self.cursor.execute(self.statement)
#		rows = self.fetchall()
#		
#		output = self.columns + "\n"
#		for row in rows:
#			output += "\t".join(self.noneToNull(row)) + "\n"
#		
#		return output.strip()

def main():
	s = Sites()
	#s.add("MDMS1", "MDMS1", 1, 0, "CL3_0", "BOXCOVER-ORIGINAL,MOVIE-ORIGINAL,POSTER-ORIGINAL,PREVIEW-ORIGINAL", 
	#	  "MDMS Distribution Template", 60, 2)
	
	s.export("/tmp/sites.tdf")
	
if __name__ == "__main__":
	main()