#!/bin/sh
LIBAIO_RPM=libaio-0.3.107-10.x86_64.rpm
ORACLE_CLIENT_RPM=oracle-instantclient11.2-basic-11.2.0.3.0-1.x86_64.rpm
CX_ORACLE_RPM=cx_Oracle-5.1.2-11g-py26-1.x86_64.rpm

LD_LIBRARY_PATH_VAR=/usr/lib/oracle/11.2/client64/lib
ORACLE_HOME_VAR=/usr/lib/oracle/11.2/client64
LOG=/opt/tandbergtv/cms/log/jboss.log

DB_USER=wfs
DB_PASS="Wf\$1234"
DB_TNS=dbserver

declare -a RPMS=($LIBAIO_RPM $ORACLE_CLIENT_RPM $CX_ORACLE_RPM)

for r in "${RPMS[@]}"
do
	rpm -qa | grep ${r%%.*} || rpm -ivh $r
done

grep LD_LIBRARY_PATH /etc/bashrc > /dev/null || echo export LD_LIBRARY_PATH=$LD_LIBRARY_PATH_VAR >> /etc/bashrc && export LD_LIBRARY_PATH=$LD_LIBRARY_PATH_VAR
grep ORACLE_HOME /etc/bashrc > /dev/null || echo export ORACLE_HOME=$ORACLE_HOME_VAR >> /etc/bashrc && export ORACLE_HOME=$ORACLE_HOME_VAR
grep LOG /etc/bashrc > /dev/null || echo export LOG=$LOG >> /etc/bashrc

mkdir -p $ORACLE_HOME/network/admin

if [ ! -e $ORACLE_HOME/network/admin/tnsnames.ora ]
then
	cp tnsnames.ora $ORACLE_HOME/network/admin/tnsnames.ora
fi

python -c "print __import__('cx_Oracle').connect('wfs/Wf\$1234@dbserver').version" > /dev/null && echo "cx_Oracle installation successful." || echo "cx_Oracle installation failed."
