#!/usr/bin/python -Qnew
#
#
#
# Copyright (c) 2009 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Michael Jones
# Created: Oct 22, 2012
# Description:
# Out of Box Deployment Script
#
# $Id: deploy_oob.py,v 1.00 2012/10/22 17:43:28 mjones Exp $
#
#
#

import os
import sys
import socket
import re
import dircache
import posix
import shutil
import errno
import subprocess
from optparse import OptionParser,OptionGroup

from xml.dom.minidom import parseString

class Tee(object):
	def __init__(self, name, mode):
		self.file = open(name, mode)
		self.stdout = sys.stdout
		sys.stdout = self
	
	def __del__(self):
		try:
			sys.stdout = self.stdout
			self.file.close()
		except AttributeError, e:
			pass
	
	def write(self, data):
		self.file.write(data)
		self.file.flush()
		self.stdout.write(data)
		self.stdout.flush()

def output(outputstr):
	'''Writes print statements to log as well as to screen'''
	print outputstr

def backupFile(fileName):
	if os.path.exists(fileName):
		shutil.copy(fileName, fileName +'_ORIG')

def makeDir(directory):
	if not os.path.exists(directory):
		os.makedirs(directory)

def chown(user, group, path, recursive=False):
	os.popen("chown %s%s:%s %s" % (["", "-R "][recursive], user, group, path))

def createSymlink(source, target):
	if not os.path.exists(target):
		os.symlink(source, target)

def checkTargetTitle():
	workflow = "/opt/tandbergtv/cms/workflow"
	rejected = workflow + "/rejected"
	templates = workflow + "/templates"
	dirlist = os.listdir(rejected)
	
	tt = filter(lambda t : "Target Title" in t, dirlist)
	if not len(tt):
		return
	else:
		os.rename(rejected + "/" + tt[0], templates + "/" + tt[0])

def getWatchfolderPath(directoryXml):
	return directoryXml.getAttribute("path")
	
def getWatchfolderDirectories():
	f = file("/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml", "r").read()
	dom = parseString(f)
	return map(getWatchfolderPath, dom.getElementsByTagName("directory"))
	

# End output


###########################################################################
#
# Main
#
###########################################################################

try:
	logFile = Tee("install.log", "w")
	
	# Check and make sure script is run by 'root'
	userlogin = os.environ.get('LOGNAME')
	if userlogin != "root":
		print 'You must run this as user root.'
		print 'Exiting...'
		sys.exit(1)
		
	# Check and make sure cms and tomcat services are stopped
	


	# Global Variables
	INSTALLDIR = os.getcwd()

	dnshostnames = [
		"vmx",
		"vmxck",
		"mdms",
		"cacs",
		"envivio",
		"edgeware",
		"edgeware.images",
		"watchpoint-app"
	]

	failure = 0
	for hostname in dnshostnames:
		try:
			socket.gethostbyname(hostname)
		except socket.gaierror:
			print "'" + hostname + "' is not a resolvable hostname, please fix..."
			failure = 1
	if failure == 1:
		print "exiting..."
		sys.exit(1)

	# Print title and version
	version = "deploy_oob v1.0 - October 22, 2012  (c) Ericsson Television.inc "
	title = "CMS OOB"

	print title
	print version,'\n'
	
	# Check if oob-* rpm is installed
	oob = os.popen("/bin/rpm -qa | egrep 'oob-'").read().strip()
	if oob == '':
		cmsobj = os.popen('service cms status', 'r').read()
		tomcatobj =os.popen('service tomcat status', 'r').read()
		if 'running' in cmsobj or 'running' in tomcatobj:
			print "exiting... cms and/or tomcat is still running and must be stopped before proceeding"
			sys.exit(1)
			
	else:
		print 'Continue with CMS-OOB initial deployment'

	# Make backup of the following configuration files:
	print 'Backup Original configuration files'
	
	filesToBackup = [
		'/etc/vsftpd/vsftpd.conf',
		'/opt/tandbergtv/cms/conf/site/dist-templates.xml',
		'/opt/tandbergtv/cms/jboss/server/standard/deploy/adiserver.ear/adi.properties',
		'/opt/tandbergtv/cms/workflow/preferences/distribution.xml',
		'/opt/tandbergtv/watchpoint/tomcat/webapps/filemanager/WEB-INF/classes/com/tandbergtv/workflow/webservice/filesubsystem/ftpconfiguration.txt',
		'/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.properties',
		'/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml'
	]
	map(backupFile, filesToBackup)
	print 'Finished backing up configuration files'


	# The order these rpms are listed matters.  
	OOBRPMLIST = [
		"oob-configurations",
		"purge-workflows",
		"remote-purge-workflows",
		"emergency-purge-workflows",
		"distribution-workflows",
		"content-processing-workflows",
		"ami-resourcetype",
		"envivio-resourcetype",
		"cacs-resourcetype",
		"variable-functions-resourcetype",
		"VerimatrixOMI",
		"verimatrix-create-key",
		"utilities-resourcetype",
		"cablelabs1_1",
		"cablelabs-3.0-metadata-plugin",
		"msmw-version"
			]

	# Generate the full command line for installing all the RPMs
	RPMCMDLINE = "/bin/rpm -Uvh --ignoreos --nodeps --force --replacepkgs"

	RPMFILELIST = []
	
	# This section will automatically add the MM rpms without regard to the version
		# number.
	dirlist = dircache.listdir(INSTALLDIR)
	for package in OOBRPMLIST:
		regexstr = package + "-[0-9.]+-[0-9]*\.\w*\.rpm"
	   	RPM_re = re.compile(regexstr)
	   	found = 0
	   	for f in dirlist:
	   		if RPM_re.match(f):
			   		outputstr = 'Adding ' + f + '...'
			   		print outputstr
			   		RPMFILELIST.append(f)
			   		found = 1
		if found == 0:
			outputstr = "Couldn't find rpm for " + package + "...skipping."
			print outputstr

	print 'Done.'
   	print ''
   	print 'Bulk installing.'

   	for f in RPMFILELIST:
   		RPMCMDLINE = RPMCMDLINE + ' ' + f

   	outputstr = 'command=' + RPMCMDLINE
   	print outputstr

	# Now install the RPMS
	os.system(RPMCMDLINE)
	
	chown('root', 'root', '/etc/vsftpd', True)
	if oob == '':
		print "Restarting vsftpd server..."
		ftp = os.popen("service vsftpd restart", "r").read()
		if "failed" in ftp.lower():
			print ftp
			print "ERROR: Failed to restart vsftpd!"


###########################################################################################

	# Post-Install


	# Adding ads ftpuser
	print 'Configure ftpusers ads and iptv'
	os.popen('useradd -d /content -m ads -p \$1\$Z6Giw8dM\$inoJyvC6w/7q27ukZabZB.')
	if oob == '':
		os.popen('useradd -d /content/ftp -m iptv; (echo iptv123; echo iptv123) | passwd iptv')
	
	# Adding required Ingest directories
	print 'Verify and correct /content required directories'
	contentDirs = [
		'/content/unmapped',
		'/content/mapped',
		'/content/derived',
		'/content/uploaded',
		'/content/txns_temp',
		'/var/ftp'
	]
	map(makeDir, contentDirs)
			
	print 'Creating CMS OOB FTP directories'
	ftpDirs = [
		
	]
	#chown(user, group, path, recursive)
	chown("nobody", "nobody", "/var/ftp", True)
	createSymlink('/content/', '/var/ftp/content')
			
	print 'Creating Content Ingest directories'
	dataDirs = [
		'/content/data',
		'/content/data/temp',
		'/content/data/mdms',
		'/content/data/failed'
	]
	dataDirs += getWatchfolderDirectories()
	map(makeDir, dataDirs)
	
	checkTargetTitle()
			
	#os.popen('chown -R nobody:nobody /var/ftp/content')
	#os.popen('chown -R nobody:nobody /var/ftp/content/data')
	
	# Commented since no HTTPS service is used for verimatrix
	# Installing the Verimatrix Certificate
	# print 'Configuring Verimatrix Installation Certificate'
	# os.popen('cd /opt/tandbergtv/cms/workflow/plugins/subsystems/Verimatrix/scripts; (echo 1) | sh installCert.sh vmx:8091')
	
	# Configure NAS IP in system.xml configuration file
	print 'Configuring the NAS IP address in the system.xml file'
	os.system("""sed -i_ORIG "s#file.*<#file://`grep /content /etc/fstab |awk '{print $1}' | sed 's/://'`<#g" /opt/tandbergtv/cms/workflow/preferences/system.xml""")


	# Finally, let the user know they're done

	print ''
	print 'Deployment OOB Installation Complete.'
	print ''

except KeyboardInterrupt:
 	print ''
	print '<CTRL>-C detected...Exiting...'

