#!/usr/bin/python -Qnew
#
#
#
# Copyright (c) 2009 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.

import os
import sys
import socket
import re
import dircache
import posix
import shutil
import errno
import subprocess
from optparse import OptionParser,OptionGroup

from xml.dom.minidom import parseString

def output(outputstr):
	'''Writes print statements to log as well as to screen'''
	print outputstr

def backupFile(fileName):
	if os.path.exists(fileName):
		shutil.copy(fileName, fileName +'_ORIG')

def makeDir(directory):
	if not os.path.exists(directory):
		os.makedirs(directory)

def chown(user, group, path, recursive=False):
	os.popen("chown %s%s:%s %s" % (["", "-R "][recursive], user, group, path))

def createSymlink(source, target):
	if not os.path.exists(target):
		os.symlink(source, target)

def getWatchfolderPath(directoryXml):
	return directoryXml.getAttribute("path")
	
def getWatchfolderDirectories():
	f = file("/opt/tandbergtv/watchpoint/tomcat/webapps/watchfolder/WEB-INF/classes/watchfolder.xml", "r").read()
	dom = parseString(f)
	return map(getWatchfolderPath, dom.getElementsByTagName("directory"))

def setupFTP():
	chown("nobody", "nobody", "/var/ftp", True)
	#Bind mount is useful instead of symlink when doing anonymous FTP because anon user doesn't have
	#access to soft link destination
	os.system('mkdir -p /var/ftp/content')
	os.system('mount --bind /content /var/ftp/content')

def installRPMs(dir):
	cmd = "/bin/rpm -Uvh --ignoreos --nodeps --force --replacepkgs " + dir + "/*.rpm"

   	outputstr = 'command=' + cmd
   	print outputstr

	os.system(cmd)

# End output


###########################################################################
#
# Main
#
###########################################################################
def main(options):
	try:
	
		# Check and make sure script is run by 'root'
		userlogin = os.environ.get('LOGNAME')
		if userlogin != "root":
			print 'You must run this as user root.'
			print 'Exiting...'
			sys.exit(1)
			
		INSTALLDIR = os.getcwd()
		
		# It's Vulcan nerve pinch time
		os.system('service cms stop; service tomcat stop; sleep 5;')
		print 'Continue with CMS-OOB initial deployment'

		installRPMs(options.rpmdir)
	
		setupFTP()
	
		#Not sure this helps if the configuration files haven't been copied yet during installation...
		print 'Creating Content Ingest directories'
		dataDirs = getWatchfolderDirectories()
		map(makeDir, dataDirs)
		
		os.system('cd dbsync/cx_Oracle && sh ./install_cx.sh')
		
		# Finally, let the user know they're done
	
		print ''
		print 'Installation complete, starting CMS'
		print ''
		os.system('service cms start; service tomcat start;')
	
	except KeyboardInterrupt:
	 	print ''
		print '<CTRL>-C detected...Exiting...'

def usage():
	return "Usage: %prog [options]"

if __name__ == "__main__":
	import optparse
	
	parser = optparse.OptionParser(usage=usage())
	parser.add_option("--rpm-dir", dest="rpmdir", metavar="rpmdir", default=".", help="RPM directory")
	#parser.add_option("--export-dir", dest="exportdir", metavar="dir", default="export", help="Directory to export to")
	#parser.add_option("--import-dir", dest="importdir", metavar="idir", default="import", help="Directory to import from")
	
	options, args = parser.parse_args()
	main(options)
