#!/bin/bash
LOGWEEK=`date +"%Y.%W"`
#LOGWEEK=`date +"%Y.%H"` #Use Hours for Debugging
LOGTIME=`date +"%s"`
LOGPATH="/var/log/cms/debug.$LOGWEEK"

#Create log folder
if [[ ! -d "$LOGPATH" ]]; then
    mkdir -p $LOGPATH
fi

pid=$(ps axww | grep "[o]rg.jboss.Main" | sed -e 's/^\s*//' | cut -d' ' -f1)
sudo -u nobody /usr/java/default/bin/jstack -l $pid > $LOGPATH/jstack.$LOGTIME
sudo -u nobody /usr/java/default/bin/jmap -histo $pid > $LOGPATH/histo.$LOGTIME
sudo -u nobody /usr/java/default/bin/jmap -F -heap $pid > $LOGPATH/heap.$LOGTIME
