#!/bin/bash

# Archive and remove the CMS debug logs.

# Find all directories starting with the name debug located in /var/log/cms, sort by oldest 
for a in `find /var/log/cms -iname "debug*" -type d | sort -n` ; do
# While the debug folder is not the latest
    if [[ $a != `find /var/log/cms -iname "debug*" -type d | sort -n -r | head -1` ]]; then
        # If the version of TAR is 22 or newer then use newer compression 
        if [[ `rpm -qa tar --queryformat='%{VERSION}' | awk -F"." '{print $2}'` -ge 22 ]]; then
            tar cvfJh $a.tar.xz $a
        else
            tar cvfjh $a.tar.gz $a
        fi
        # Remove log directory and files after archive 
        rm -rf $a
    fi
done