#!/bin/bash

# Decalare Variables 
START=$(date +%s)
TIMESTAMP=`date --utc -d "@$(( $START ))" +%Y%m%d_%H%M%S`
CMSAUDITARCHIVE="/root/cms_system_audit_$TIMESTAMP"
LOGPATH="/root/cms_system_audit.$START.tmp"

## Generic Message

## Create Temp Logging Folder
if [[ ! -d "$LOGPATH" ]]; then
    mkdir -p $LOGPATH
    echo -e "Creating $LOGPATH"
fi

## General Data Collection
echo "Collecting General Information About The System"
uptime >                 $LOGPATH/uptime.log
dmidecode >              $LOGPATH/dmidecode.log
mount >                  $LOGPATH/mount.log
ifconfig >               $LOGPATH/ifconfig.log
hostname >               $LOGPATH/hostname.log
netstat -tulpn >         $LOGPATH/netstat.log
cp /etc/fstab            $LOGPATH/
cp /etc/hosts            $LOGPATH/
cp /etc/ssh/sshd_config  $LOGPATH/
cp /etc/group            $LOGPATH/
cp /etc/passwd           $LOGPATH/
rpm -qa >                $LOGPATH/installed.rpms
env >                    $LOGPATH/env.log
ps axu >                 $LOGPATH/ps-aux.log

#mpstat -P ALL 1 10 (CPU Info, 10 times 1 second apart)
#vmstat -t -S M 1 10  (Memory usage, 10 times 1 second apart)
#iostat -m -t 1 10 (I/O usage, 10 times 1 second apart)
#iostat -m -t -N 1 10 (LVM usage, 10 times 1 sec apart)

## Formated History (To find out what commands were issued when)
echo "Collecting User History"
for u in `find / -name .bash_history 2>/dev/null` 
do
    histfile=`echo $u | sed 's|/||g'`
    cp $u $LOGPATH/$histfile
done

## rPath 
if [[ -z `conary | grep "command no found"` ]]; then 
    echo "Collecting rPath Information"
    conary --version >       $LOGPATH/conary.version
    conary q >               $LOGPATH/installed.conary
fi

## SA Log Collection
echo -n "Collectiing SA Logs"
if [[ -d "/var/log/sa/" ]]; then
    mkdir -p $LOGPATH/sa
    for i in `ls /var/log/sa | grep -v 'sar'`
    do
        echo -n "."
        FSTAMP=`ls -l --time-style=+'%s' /var/log/sa/$i | awk {'print $6'}`
        sar -A -f /var/log/sa/$i > $LOGPATH/sa/$FSTAMP.$i.log
    done
    echo "Done"
fi
    
## CMS Applaince Data Collection
if ls /opt/tandbergtv/cms/conf/workflow/*.lic &> /dev/null ; then
    echo "Collecting CMS Applaince Information"
    mkdir -p $LOGPATH/{services,cms,watchpoint,RCSScheduler}
    cp    /etc/init.d/alerts                                                  $LOGPATH/services/
    cp    /etc/init.d/cms                                                     $LOGPATH/services/
    cp    /etc/init.d/rmserver                                                $LOGPATH/services/
    cp    /etc/init.d/RCSSchedulerService                                     $LOGPATH/services/
    cp    /etc/init.d/tomcat                                                  $LOGPATH/services/
    cp    /etc/init.d/xportmanager                                            $LOGPATH/services/
    cp    /etc/init.d/xporttomcat                                             $LOGPATH/services/
    cp    /opt/tandbergtv/cms/product.properties                              $LOGPATH/cms/
    cp    /usr/local/n2bb/conf/alerts_settings.conf                           $LOGPATH/cms/
    cp    /opt/tandbergtv/cms/jboss/server/standard/deploy/epgmanager-ds.xml  $LOGPATH/cms/
    cp    /opt/tandbergtv/cms/jboss/server/standard/deploy/jms-ds.xml         $LOGPATH/cms/ 
    cp    /opt/tandbergtv/cms/jboss/server/standard/deploy/neptune-ds.xml     $LOGPATH/cms/   
    cp    /opt/tandbergtv/cms/jboss/server/standard/deploy/oracle-ds.xml      $LOGPATH/cms/    
    ln -s /opt/tandbergtv/cms/workflow/stats/                                 $LOGPATH/cms/stats
    ln -s /opt/tandbergtv/cms/log/                                            $LOGPATH/cms/log
    #ln -s /opt/tandbergtv/cms/workflow/mq/                                    $LOGPATH/cms/mq
    ln -s /opt/tandbergtv/cms/conf/                                           $LOGPATH/cms/conf
    ln -s /opt/tandbergtv/watchpoint/log/                                     $LOGPATH/watchpoint/log
    ln -s /usr/local/tstv/RCSScheduler/config/                                $LOGPATH/RCSScheduler/conf
else 
    echo "CMS is Unlicensed on System"  $LOGPATH/CMS_NOT_ENABLED
fi

## VCS Data Collection
    echo "Collecting VCS Information"
if ls /etc/vx/licenses/lic/*.vxlic &> /dev/null ; then
    mkdir -p $LOGPATH/vcs
    ln -s /var/VRTSvcs/log/                         $LOGPATH/vcs/log
    ln -s /etc/VRTSvcs/conf/config/                 $LOGPATH/vcs/config
    cp /etc/llttab                                  $LOGPATH/vcs/
    cp /etc/gabtab                                  $LOGPATH/vcs/
    cp /etc/llthosts                                $LOGPATH/vcs/
    hastatus -sum >                                 $LOGPATH/vcs/hastatus
    hagrp -display                                  $LOGPATH/vcs/hagrp
    hares -display                                  $LOGPATH/vcs/hares
else 
    echo "VCS is Unlicensed on System"              $LOGPATH/vcs/VCS_NOT_ENABLED
fi

## RM Server Stuff
if ls /usr/local/tstv/RMScheduler/config/*.lic &> /dev/null ; then
    ln -s /usr/local/tstv/RMScheduler/log      $LOGPATH/tstv/rmlog
    ln -s /usr/local/tstv/RMScheduler/config   $LOGPATH/tstv/rmconfig
    ln -s /usr/local/tstv/jboss/log            $LOGPATH/tstv/jbosslog
    cp /usr/local/tstv/jboss/bin/run.sh        $LOGPATH/tstv/.
    cp /usr/local/tstv/jboss/bin/run.conf      $LOGPATH/tstv/.
    cp /usr/local/tstv/jboss/server/default/deploy/RMWeb.war/WEB-INF/classes/RMWebConfig.properties $LOGPATH/tstv/.
else 
    echo "RM is Unlicensed on System"          $LOGPATH/tstv/RM_NOT_ENABLED
fi
     
## RTC Server Stuff
if [[ -d `ls /usr/local/tstv/rtc/` ]]; then
    ln -s /usr/local/tstv/rtc/logs             $LOGPATH/rtc/logs
    ln -s /usr/local/tstv/rtc/config           $LOGPATH/rtc/config
else 
    echo "RTC is Unlicensed on System"         $LOGPATH/rtc/RTC_NOT_ENABLED
fi

## Database Stuff
if [[ -z `service oracle status | grep "unrecognized service"` ]]; then
    service oracle status  2>&1 | tee $LOGPATH/oracle.status
    su - oracle -c "sqlplus -S /nolog  <<EOF
    connect / as sysdba
    set termout off
    set head off
    set feed off
    set serveroutput on
    set echo off
    select 'CMS Database details...' from dual;
    select '      Count of Templates = '||count(*) from wfs.jbpm_processdefinition 
    union all
    select '      Count of Titles = '||count(*) from wfs.pmm_title 
    union all
    select '      Count of Work Orders = '||count(*) from wfs.jbpm_processinstance;
    EOF" >> $LOGPATH/oracle.queries
    echo -e "" 
fi

## Package up all files for shipping
if [[ `rpm -qa tar --queryformat='%{VERSION}' | awk -F"." '{print $2}'` -ge 22 ]]; then
    echo "Generating archive $CMSAUDITARCHIVE.tar.xz"
    echo "   This may take a while..."
    tar cvfJh $CMSAUDITARCHIVE.tar.xz  $LOGPATH
else
    echo "Generating archive $CMSAUDITARCHIVE.tar.bz2"
    echo "   This may take a while..."
    tar cvfjh $CMSAUDITARCHIVE.tar.bz2 $LOGPATH
fi

## Remove Temp Files
rm -rf $LOGPATH


