/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class XslTranslator
implements ITranslator {
    private final Logger logger = Logger.getLogger(this.getClass());
    private TransformerFactory tf;
    private InputStream xslStream;
    private Transformer transformer;
    private ClassLoader classLoader;

    @Override
    public void setXslStream(InputStream xslStream) {
        this.xslStream = xslStream;
        try {
            this.tf = this.getTransformerFactory();
            this.transformer = this.tf.newTransformer(new StreamSource(this.xslStream));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document translate(Document doc) throws TranslationException {
        this.logger.debug((Object)"In Translate");
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = XmlUtil.borrowDocumentBuilder();
            Document docOut = dBuilder.newDocument();
            DOMResult result = new DOMResult(docOut);
            this.transformer.transform(new DOMSource(doc), result);
            Document document = docOut;
            return document;
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(dBuilder);
        }
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private TransformerFactory getTransformerFactory() {
        if (this.tf == null) {
            this.tf = XmlUtil.createTransformerFactory(this.classLoader);
            this.tf.setURIResolver(new ResourceResolver(this.classLoader));
        }
        return this.tf;
    }
}

