/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util.binder;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFAssetToDocConverter {
    private DocumentBuilder builder;
    private Document doc;
    private static final Logger logger = Logger.getLogger(ECMFAssetToDocConverter.class);

    public Document convert(List<Asset> assets) {
        try {
            this.builder = XmlUtil.borrowDocumentBuilder();
            this.doc = this.builder.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(this.builder);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        if (assets.size() > 1) {
            logger.warn((Object)(assets.size() + " root assets have been requested to be converted into ECMF doc." + " Will convert only the first one."));
        }
        Asset asset = assets.get(0);
        elements.add(this.assetRoller(asset));
        Element root = this.doc.createElement("ECMFSpec");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "ECMFSpec.xsd");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("documentId", String.valueOf(asset.getId()));
        root.setAttribute("revision", String.valueOf(asset.getLatestRevisionNumber()));
        if (asset.getOriginalAssetID() != null) {
            root.setAttribute("originalDocumentId", String.valueOf(asset.getOriginalAssetID()));
        }
        if (asset.getOriginalRevisionNumber() != null) {
            root.setAttribute("originalDocumentRevision", String.valueOf(asset.getOriginalRevisionNumber()));
        }
        if (((Group)asset).getSeriesDocumentId() != null) {
            root.setAttribute("seriesDocumentId", String.valueOf(((Group)asset).getSeriesDocumentId()));
        }
        if (((Group)asset).getSeasonAssetId() != null) {
            root.setAttribute("seasonAssetId", String.valueOf(((Group)asset).getSeasonAssetId()));
        }
        this.doc.appendChild(root);
        for (Element element : elements) {
            if (element == null) continue;
            Node elementCopy = this.doc.importNode(element, true);
            root.appendChild(elementCopy);
        }
        return this.doc;
    }

    private Element assetRoller(Asset rootAsset) {
        Element rootAssetElement = this.buildAssetElement(rootAsset, true);
        List<Asset> titleAssets = rootAsset.getAllAssetsOfType(Item.ItemType.TITLE.name());
        if (titleAssets != null && titleAssets.size() == 1) {
            Element titleElement = this.buildAssetElement(titleAssets.get(0), true);
            for (Relation r : titleAssets.get(0).getRelations()) {
                if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
                Element fileElement = this.buildFileElement(r.getTargetAsset());
                titleElement.appendChild(fileElement);
            }
            titleElement.appendChild(this.buildFieldsElement(titleAssets.get(0)));
            Element upElement = this.buildUnparsableFieldsElement(titleAssets.get(0));
            if (upElement != null) {
                titleElement.appendChild(upElement);
            }
            rootAssetElement.appendChild(titleElement);
        }
        this.addMovieOrPreviewElements(rootAsset, rootAssetElement, Group.GroupType.MOVIE.name());
        this.addMovieOrPreviewElements(rootAsset, rootAssetElement, Group.GroupType.PREVIEW.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.POSTER.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.BOXCOVER.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.TRICK.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.ENCRYPTED.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.BARKER.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.MOVIESEGMENTGROUP.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.PREVIEWSEGMENTGROUP.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.DISPLAY.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.GAME.name());
        this.addMultipleAssetElements(rootAsset, rootAssetElement, Item.ItemType.AUDIO.name());
        this.addSeasonElements(rootAsset, rootAssetElement, Group.GroupType.SEASON.name());
        for (Relation r : rootAsset.getRelations()) {
            if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            rootAssetElement.appendChild(fileElement);
        }
        rootAssetElement.appendChild(this.buildFieldsElement(rootAsset));
        Element upElement = this.buildUnparsableFieldsElement(rootAsset);
        if (upElement != null) {
            rootAssetElement.appendChild(upElement);
        }
        return rootAssetElement;
    }

    private void addAssetElement(Asset packageAsset, Element packageElement, String itemType) {
        List<Asset> assets = packageAsset.getAllAssetsOfType(itemType);
        if (assets == null || assets.size() == 0) {
            return;
        }
        if (assets.size() > 1) {
            logger.warn((Object)("Found multiple assets of type: " + itemType + " Will add the first one to the doc."));
        }
        Element assetElement = this.buildAssetElement(assets.get(0), true);
        for (Relation r : assets.get(0).getRelations()) {
            if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            assetElement.appendChild(fileElement);
        }
        Element fieldsElement = this.buildFieldsElement(assets.get(0));
        assetElement.appendChild(fieldsElement);
        Element upFieldsElement = this.buildUnparsableFieldsElement(assets.get(0));
        if (upFieldsElement != null) {
            assetElement.appendChild(upFieldsElement);
        }
        packageElement.appendChild(assetElement);
    }

    private void addMultipleAssetElements(Asset parentAsset, Element parentElement, String itemType) {
        List<Asset> assets = parentAsset.getAllAssetsOfType(itemType);
        if (assets == null || assets.size() == 0) {
            return;
        }
        for (Asset a : assets) {
            Element assetElement = this.buildAssetElement(a, true);
            for (Relation r : a.getRelations()) {
                if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
                Element fileElement = this.buildFileElement(r.getTargetAsset());
                assetElement.appendChild(fileElement);
            }
            Element fieldsElement = this.buildFieldsElement(a);
            assetElement.appendChild(fieldsElement);
            Element upFieldsElement = this.buildUnparsableFieldsElement(a);
            if (upFieldsElement != null) {
                assetElement.appendChild(upFieldsElement);
            }
            parentElement.appendChild(assetElement);
        }
    }

    private void addMovieOrPreviewElements(Asset packageAsset, Element packageElement, String groupType) {
        List<Asset> assets = packageAsset.getAllAssetsOfType(groupType);
        if (assets != null) {
            for (Asset a : assets) {
                Element assetElement = this.buildAssetElement(a, true);
                for (Relation r : a.getRelations()) {
                    if (!r.getTargetAsset().getType().equals(Item.ItemType.LOGICALCLIP.name())) continue;
                    Element logicalClipElement = this.buildLogicalClipElement(r.getTargetAsset());
                    assetElement.appendChild(logicalClipElement);
                }
                for (Relation r : a.getRelations()) {
                    if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
                    Element fileElement = this.buildFileElement(r.getTargetAsset());
                    assetElement.appendChild(fileElement);
                }
                Element fieldsElement = this.buildFieldsElement(a);
                assetElement.appendChild(fieldsElement);
                Element upFieldsElement = this.buildUnparsableFieldsElement(a);
                if (upFieldsElement != null) {
                    assetElement.appendChild(upFieldsElement);
                }
                packageElement.appendChild(assetElement);
            }
        }
    }

    private Element buildLogicalClipElement(Asset logicalClipAsset) {
        Element logicalClipAssetElement = this.buildAssetElement(logicalClipAsset, false);
        for (Relation r : logicalClipAsset.getRelations()) {
            if (!r.getTargetAsset().getAssetType().equals(Item.ItemType.FILE.name())) continue;
            Element fileElement = this.buildFileElement(r.getTargetAsset());
            logicalClipAssetElement.appendChild(fileElement);
        }
        Element fields = this.buildFieldsElement(logicalClipAsset);
        logicalClipAssetElement.appendChild(fields);
        Element upFields = this.buildUnparsableFieldsElement(logicalClipAsset);
        if (upFields != null) {
            logicalClipAssetElement.appendChild(upFields);
        }
        return logicalClipAssetElement;
    }

    private void addSeasonElements(Asset seriesAsset, Element seriesElement, String groupType) {
        List<Asset> assets = seriesAsset.getAllAssetsOfType(groupType);
        if (assets != null) {
            for (Asset a : assets) {
                Element assetElement = this.buildAssetElement(a, true);
                this.addMultipleAssetElements(a, assetElement, Item.ItemType.POSTER.name());
                this.addMultipleAssetElements(a, assetElement, Item.ItemType.BOXCOVER.name());
                for (Relation r : a.getRelations()) {
                    if (!r.getTargetAsset().getType().equals(Item.ItemType.FILE.name())) continue;
                    Element fileElement = this.buildFileElement(r.getTargetAsset());
                    assetElement.appendChild(fileElement);
                }
                Element fieldsElement = this.buildFieldsElement(a);
                assetElement.appendChild(fieldsElement);
                Element upFieldsElement = this.buildUnparsableFieldsElement(a);
                if (upFieldsElement != null) {
                    assetElement.appendChild(upFieldsElement);
                }
                seriesElement.appendChild(assetElement);
            }
        }
    }

    private Element buildAssetElement(Asset asset, boolean setOriginalAssetId) {
        Element assetElement = this.doc.createElement(AssetType.valueOf(asset.getAssetType()).toString());
        assetElement.setAttribute("assetId", String.valueOf(asset.getTTVId().getId()));
        if (setOriginalAssetId && asset.getOriginalAssetID() != null) {
            assetElement.setAttribute("originalAssetId", String.valueOf(asset.getOriginalAssetID()));
        }
        return assetElement;
    }

    private Element buildFieldsElement(Asset asset) {
        ArrayList<Field> parsableFields = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (!f.getParsable().booleanValue()) continue;
            parsableFields.add(f);
        }
        NodeList sourceFieldNodes = new ECMFFieldBinder().buildXml(parsableFields).getDocumentElement().getChildNodes();
        Element fields = this.doc.createElement("Fields");
        for (int i = 0; i < sourceFieldNodes.getLength(); ++i) {
            Node item = sourceFieldNodes.item(i);
            if (!(item instanceof Element)) continue;
            fields.appendChild(this.doc.importNode(item, true));
        }
        return fields;
    }

    private Element buildUnparsableFieldsElement(Asset asset) {
        ArrayList<Field> unParsableFields = new ArrayList<Field>();
        for (Field f : asset.getFields()) {
            if (f.getParsable().booleanValue()) continue;
            unParsableFields.add(f);
        }
        Document upfs = new ECMFFieldBinder().buildUnparsableFields(unParsableFields);
        if (upfs == null) {
            return null;
        }
        NodeList sourceFieldNodes = upfs.getDocumentElement().getChildNodes();
        Element upFields = this.doc.createElement("UnparsableFields");
        for (int i = 0; i < sourceFieldNodes.getLength(); ++i) {
            Node item = sourceFieldNodes.item(i);
            if (!(item instanceof Element)) continue;
            upFields.appendChild(this.doc.importNode(item, true));
        }
        return upFields;
    }

    private Element buildFileElement(Asset fileAsset) {
        Element fileElement = this.doc.createElement(AssetType.FILE.toString());
        fileElement.setAttribute("assetId", String.valueOf(fileAsset.getTTVId().getId()));
        for (Relation r : fileAsset.getRelations()) {
            if (!r.getTargetAsset().getAssetType().equals(Item.ItemType.FILE.name())) continue;
            Element childFileElement = this.buildFileElement(r.getTargetAsset());
            fileElement.appendChild(childFileElement);
        }
        Element fileFields = this.buildFieldsElement(fileAsset);
        fileElement.appendChild(fileFields);
        Element upFieldsElement = this.buildUnparsableFieldsElement(fileAsset);
        if (upFieldsElement != null) {
            fileElement.appendChild(upFieldsElement);
        }
        return fileElement;
    }
}

