/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.search.QueryBuilderHelper;
import java.util.ArrayList;
import java.util.List;

public class TitleSearchQueryBuilder {
    public static final String TITLE_STATUS = "status";
    private static final String TITLE_ID = "id";
    private static final String CONTENT_CLASS = "contentClassId";
    private static final String PARTNER_ID = "partnerId";
    private static final String DOCUMENT_ID = "documentId";
    private static final String ORIGINAL_ID = "originalId";
    private static final String ORIGINAL_VERSION = "originalVersion";
    private static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    private static final String RETIRMENT_DATE = "retirementDate";

    public String getCondition(Predicate predicate, String alias) {
        LogicalOperator lop = predicate.getNot() != false ? predicate.getOperator().invert() : predicate.getOperator();
        List<Object> values = new ArrayList();
        if (predicate instanceof PredicateRightValue) {
            values = ((PredicateRightValue)predicate).getValue();
        }
        String fieldName = this.getField(predicate.getFieldLeft());
        String dataType = predicate.getDataType();
        if (dataType == null) {
            dataType = this.getDataType(predicate.getFieldLeft());
        }
        if (predicate.getFieldLeft().equals(TITLE_STATUS)) {
            values = this.convertTitleStatus(values);
            dataType = "integer";
        }
        return QueryBuilderHelper.getCondition(fieldName, lop, values, alias, dataType, predicate.getIgnoreCase());
    }

    private String getField(String fieldName) {
        return DBNameFinder.getInstance().getColumnName(Title.class, fieldName);
    }

    private String getDataType(String fieldName) {
        if (fieldName.equals(TITLE_ID)) {
            return "integer";
        }
        if (fieldName.equals(TITLE_STATUS)) {
            return "integer";
        }
        if (fieldName.equals(CONTENT_CLASS)) {
            return "integer";
        }
        if (fieldName.equals(PARTNER_ID)) {
            return "integer";
        }
        if (fieldName.equals(DOCUMENT_ID)) {
            return "integer";
        }
        if (fieldName.equals(ORIGINAL_ID)) {
            return "integer";
        }
        if (fieldName.equals(ORIGINAL_VERSION)) {
            return "integer";
        }
        if (fieldName.equals(LAST_MODIFIED_TIME)) {
            return "date";
        }
        if (fieldName.equals(RETIRMENT_DATE)) {
            return "date";
        }
        throw new RuntimeException("could not determine datatype for field: " + fieldName);
    }

    private List<String> convertTitleStatus(List<String> statuses) {
        ArrayList<String> result = new ArrayList<String>();
        for (String str : statuses) {
            result.add(String.valueOf(TitleStatus.valueOf((String)str).ordinal()));
        }
        return result;
    }
}

