/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.resource;

import com.tandbergtv.cms.portal.util.locale.ResourceBundleLocaleModifier;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.resource.FileManager;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Query;
import org.hibernate.Session;

public class TitleResourceManager
implements ITitleResourceManager {
    private static final Logger logger = Logger.getLogger(TitleResourceManager.class);
    private static final String CLEAN_TIME = "cleanTime";
    private static final String CLEAN_WAIT_PERIOD = "cleanWaitPeriod";
    private static final long DAY_IN_MS = 86400000L;
    private static final int CLEAN_WAIT_PERIOD_VALUE = 5;
    private static final String CLEAN_TIME_FORMAT = "HH:mm:ss";
    private ISchedulerService<Void> schedulerService;
    private FileManager fileManager = new FileManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TitleResource get(Long id) {
        Transaction transaction = this.suspendTransaction();
        try {
            TitleResource titleResource = this.getInternal(id);
            return titleResource;
        }
        finally {
            this.resumeTransaction(transaction);
        }
    }

    @Transactional
    private TitleResource getInternal(Long id) {
        Long l = id;
        return (TitleResource)TitleResourceManager.getInternal_aroundBody1$advice(this, l, TransactionEnforcer.aspectOf(), TitleResourceManager.class.getDeclaredMethod("getInternal", Long.class).getAnnotation(Transactional.class), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TitleResource save(TitleResource resource) {
        Transaction transaction = this.suspendTransaction();
        try {
            TitleResource titleResource = this.saveInternal(resource);
            return titleResource;
        }
        finally {
            this.resumeTransaction(transaction);
        }
    }

    @Transactional
    private TitleResource saveInternal(TitleResource resource) {
        TitleResource titleResource = resource;
        return (TitleResource)TitleResourceManager.saveInternal_aroundBody3$advice(this, titleResource, TransactionEnforcer.aspectOf(), TitleResourceManager.class.getDeclaredMethod("saveInternal", TitleResource.class).getAnnotation(Transactional.class), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Long id) {
        Transaction transaction = this.suspendTransaction();
        try {
            boolean bl = this.deleteInternal(id);
            return bl;
        }
        finally {
            this.resumeTransaction(transaction);
        }
    }

    @Transactional
    private boolean deleteInternal(Long id) {
        Long l = id;
        return Conversions.booleanValue((Object)TitleResourceManager.deleteInternal_aroundBody5$advice(this, l, TransactionEnforcer.aspectOf(), TitleResourceManager.class.getDeclaredMethod("deleteInternal", Long.class).getAnnotation(Transactional.class), null));
    }

    @Override
    public List<TitleResource> getByTitle(Long titleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("titleID", titleId);
        return this.getList("TitleResource.GetByTitle", parameters);
    }

    @Override
    public List<TitleResource> getOrphans() {
        return this.getList("TitleResource.GetOrphans", null);
    }

    @Override
    public List<TitleResource> getByDeletedTitles() {
        return this.getList("TitleResource.GetByDeletedTitles", null);
    }

    @Override
    public List<TitleResource> getByPath(String resourcePath) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resourcePath", resourcePath);
        return this.getList("TitleResource.GetByResourcePath", parameters);
    }

    @Transactional
    private List<TitleResource> getList(String queryName, Map<String, Object> parameters) {
        String string = queryName;
        Map<String, Object> map = parameters;
        return (List)TitleResourceManager.getList_aroundBody7$advice(this, string, map, TransactionEnforcer.aspectOf(), TitleResourceManager.class.getDeclaredMethod("getList", String.class, Map.class).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
        this.schedulerService = new Scheduler("title-resource", 1, 1);
        this.schedulerService.start();
        long now = this.getCurrentTime().getTime();
        long cleanTime = this.getCleanTime().getTime();
        long delay = cleanTime - now;
        if (delay < 0L) {
            delay += 86400000L;
        }
        this.schedulerService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    TitleResourceManager.this.cleanTitleResources();
                }
                catch (Throwable t) {
                    String msg = "Severe error when cleaning title resources for deleted titles and orphans.";
                    logger.error((Object)msg, t);
                }
            }
        }, delay, 86400000L);
    }

    public void stop() {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
        this.schedulerService = null;
    }

    private TransactionManager getTransactionManager() {
        try {
            InitialContext context = new InitialContext();
            return (TransactionManager)context.lookup("java:TransactionManager");
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to lookup the transaction manager.", (Throwable)e);
            return null;
        }
    }

    private Transaction suspendTransaction() {
        Transaction transaction = null;
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager != null) {
            try {
                transaction = transactionManager.suspend();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure suspending current transaction.", (Throwable)e);
            }
        }
        return transaction;
    }

    private void resumeTransaction(Transaction transaction) {
        TransactionManager transactionManager;
        if (transaction != null && (transactionManager = this.getTransactionManager()) != null) {
            try {
                transactionManager.resume(transaction);
            }
            catch (Exception e) {
                logger.warn((Object)"Failure resuming current transaction.", (Throwable)e);
            }
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private void cleanTitleResources() {
        try {
            logger.info((Object)"Executing scheduled task to clean title resources for orphan resources and deleted titles.");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("days", this.getCleanWaitPeriod());
            List<TitleResource> resources = this.getList("TitleResource.GetForClean", parameters);
            if (resources.size() > 0) {
                logger.info((Object)("Found " + resources.size() + " title resources for deletion " + "that are orphans or belong to deleted titles."));
            }
            for (TitleResource resource : resources) {
                try {
                    this.delete(resource.getId());
                }
                catch (Exception e) {
                    logger.error((Object)("Failure when cleaning title[#" + resource.getTitleId() + "] resource: " + resource.getResourcePath()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to get title resources for orphan and deleted titles for cleanup.";
            logger.error((Object)msg, (Throwable)e);
        }
    }

    private Date getCleanTime() {
        Date cleanTime = null;
        String value = null;
        try {
            String string = this.getClass().getName();
            ResourceBundle bundle = TitleResourceManager.getBundle_aroundBody9$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
            value = bundle.getString(CLEAN_TIME);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title resource clean time.", (Throwable)e);
        }
        SimpleDateFormat format = new SimpleDateFormat(CLEAN_TIME_FORMAT);
        if (value != null && value.trim().length() > 0) {
            try {
                cleanTime = format.parse(value);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse title resource clean time: '" + value + "' using format: " + CLEAN_TIME_FORMAT + ", using default."), (Throwable)e);
            }
        }
        if (cleanTime == null) {
            cleanTime = new Date();
        }
        return cleanTime;
    }

    private Date getCurrentTime() {
        try {
            SimpleDateFormat format = new SimpleDateFormat(CLEAN_TIME_FORMAT);
            return format.parse(format.format(new Date()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get current time.", e);
        }
    }

    private int getCleanWaitPeriod() {
        int cleanWaitPeriod = -1;
        String value = null;
        try {
            String string = this.getClass().getName();
            ResourceBundle bundle = TitleResourceManager.getBundle_aroundBody11$advice(this, string, ResourceBundleLocaleModifier.aspectOf(), string, null);
            value = bundle.getString(CLEAN_WAIT_PERIOD);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title resource clean wait period.", (Throwable)e);
        }
        if (value != null && value.trim().length() > 0) {
            try {
                cleanWaitPeriod = Integer.parseInt(value);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse title resource clean wait period: '" + value + "' , using default."), (Throwable)e);
            }
        }
        if (cleanWaitPeriod <= 0) {
            cleanWaitPeriod = 5;
        }
        return cleanWaitPeriod;
    }

    private static final /* synthetic */ TitleResource getInternal_aroundBody0(TitleResourceManager this_, Long id) {
        return (TitleResource)this_.getSession().load(TitleResource.class, (Serializable)id);
    }

    private static final /* synthetic */ Object getInternal_aroundBody1$advice(TitleResourceManager this_, Long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleResourceManager.getInternal_aroundBody0(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleResource object = TitleResourceManager.getInternal_aroundBody0(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ TitleResource saveInternal_aroundBody2(TitleResourceManager this_, TitleResource resource) {
        this_.getSession().persist((Object)resource);
        return resource;
    }

    private static final /* synthetic */ Object saveInternal_aroundBody3$advice(TitleResourceManager this_, TitleResource resource, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleResourceManager.saveInternal_aroundBody2(this_, resource);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleResource object = TitleResourceManager.saveInternal_aroundBody2(this_, resource);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean deleteInternal_aroundBody4(TitleResourceManager this_, Long id) {
        boolean result = false;
        Session session = this_.getSession();
        TitleResource entity = (TitleResource)session.get(TitleResource.class, (Serializable)id);
        if (entity != null) {
            try {
                File file = new File(entity.getResourcePath());
                this_.fileManager.deleteFile(file);
                if (file.exists()) {
                    logger.warn((Object)("Failure deleting title[#" + entity.getTitleId() + "] resource: " + file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failure deleting title[#" + entity.getTitleId() + "] resource: " + entity.getResourcePath()));
            }
            session.delete((Object)entity);
            result = true;
        }
        return result;
    }

    private static final /* synthetic */ Object deleteInternal_aroundBody5$advice(TitleResourceManager this_, Long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)TitleResourceManager.deleteInternal_aroundBody4(this_, id));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)TitleResourceManager.deleteInternal_aroundBody4(this_, id));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getList_aroundBody6(TitleResourceManager this_, String queryName, Map parameters) {
        Query query = this_.getSession().getNamedQuery(queryName);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                query.setParameter(key, parameters.get(key));
            }
        }
        return query.list();
    }

    private static final /* synthetic */ Object getList_aroundBody7$advice(TitleResourceManager this_, String queryName, Map parameters, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleResourceManager.getList_aroundBody6(this_, queryName, parameters);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = TitleResourceManager.getList_aroundBody6(this_, queryName, parameters);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody8(TitleResourceManager titleResourceManager, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody9$advice(TitleResourceManager this_, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody10(TitleResourceManager titleResourceManager, String string) {
        return ResourceBundle.getBundle(string);
    }

    private static final /* synthetic */ ResourceBundle getBundle_aroundBody11$advice(TitleResourceManager this_, String arg0, ResourceBundleLocaleModifier ajc$aspectInstance, String baseName, AroundClosure ajc$aroundClosure) {
        return ResourceBundle.getBundle(baseName, ResourceBundleLocaleModifier.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$com_tandbergtv_cms_portal_util_locale_ResourceBundleLocaleModifier$locale((ResourceBundleLocaleModifier)ajc$aspectInstance));
    }
}

