/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RequiredFileFieldsConfig {
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PMM_CONFIG_DIR = "pmm";
    private static final String CONFIG_FILE = "requiredFileFields.txt";
    private static RequiredFileFieldsConfig _instance;
    private List<String> requiredFields = new ArrayList<String>();

    public static synchronized RequiredFileFieldsConfig getInstance() throws IOException {
        if (_instance == null) {
            File productConfDir = new File(System.getProperty(PRODUCT_DIR), "conf");
            File pmmConfDir = new File(productConfDir, PMM_CONFIG_DIR);
            File confFile = new File(pmmConfDir, CONFIG_FILE);
            _instance = new RequiredFileFieldsConfig(confFile);
        }
        return _instance;
    }

    private RequiredFileFieldsConfig(File file) throws IOException {
        this.loadFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                this.requiredFields.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public List<String> getRequiredFields() {
        return this.requiredFields;
    }
}

