/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.partner;

import com.tandbergtv.cms.partner.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContentClassPartnerConverter {
    ContentClassServiceHibernate service = new ContentClassServiceHibernate();

    public void convertContentClassPartner() throws ContentClassPersistenceException {
        this.service.init();
        this.service.beginTransaction();
        List<ContentClassPartner> list = this.service.getAllContentClassPartnersWithoutMetadata();
        if (list != null) {
            for (ContentClassPartner contentClassPartner : list) {
                ContentClassMetadata contentClassMetadata;
                ContentClassPartner contentClassPartner2 = this.service.getContentClassPartnerMetadata(contentClassPartner.getContentClassId(), contentClassPartner.getPartnerId());
                if (contentClassPartner2 == null || (contentClassMetadata = contentClassPartner2.getMetadata()) == null) continue;
                Collection collection = contentClassMetadata.getAssetList();
                for (ContentClassAsset contentClassAsset : collection) {
                    Collection collection2 = contentClassAsset.getFieldList();
                    if (collection2 == null) continue;
                    Iterator iterator = collection2.iterator();
                    while (iterator.hasNext()) {
                        ContentClassField contentClassField = (ContentClassField)iterator.next();
                        if (this.hasNonDefaultPartnerValues(contentClassField)) continue;
                        iterator.remove();
                    }
                }
                contentClassPartner2.setMetadata(contentClassMetadata);
                contentClassPartner.setMetadata(contentClassMetadata);
            }
            this.saveContentClassPartnerClasses(list);
            this.service.commit();
            this.service.closeSession();
        }
    }

    private void saveContentClassPartnerClasses(List<ContentClassPartner> list) throws ContentClassPersistenceException {
        for (ContentClassPartner contentClassPartner : list) {
            this.service.saveContentClassPartner(contentClassPartner);
        }
    }

    public boolean hasNonDefaultPartnerValues(ContentClassField contentClassField) {
        if (contentClassField.getDefaultValue() != null && !contentClassField.getDefaultValue().trim().isEmpty()) {
            return true;
        }
        if (contentClassField.isLocked()) {
            return true;
        }
        return this.hasValues(contentClassField.getDisabledOptionKeys());
    }

    private boolean hasValues(Set<String> set) {
        return set != null && !set.isEmpty();
    }
}

