#!/bin/bash
##############################################################################################################
##    Script Name    : extractTAR.sh                                                                        ##
##    Author         : Matthew Kruer                                                                        ##
##    Created on     : 07/09/2014                                                                           ##
##    Usage          : ./extractTAR.sh /path/restore_excludes /path/tarball.tgz                             ##
##    Purpose        : Extracts Archive to prepared 2.5-4.0 environment                                     ##
##                                                                                                          ##
##############################################################################################################

printf "Starting CMS Configuration File Merger\n"

#Require Valid Search Script
if [[ -z $1 ]]; then
    printf "Please Supply The Location to CMS Merge Exclude List"
    exit 1
else 
    RESTORE_CONF=$1
fi

#Valid Tarball
if [[ -z $2 ]]; then
    printf "Please Supply Location to CMS CommonBackup Tarball\n"
    exit 1
elif ! tar tzf $2 >/dev/null ; then 
    printf "Invalid CMS CommonBackup Tarball\n"
    exit 1
else
    tar xvf $2 -C / --exclude-from=$RESTORE_CONF || die "Failed to extract from backup file"
fi
