#!/bin/bash
##############################################################################################################
##    Script Name    : postUpgrade.sh                                                                       ##
##    Author         : Matthew Kruer                                                                        ##
##    Created on     : 07/09/2014                                                                           ##
##    Usage          : ./postUpgrade.sh                                                                     ##
##    Purpose        : Runs Additional Post Upgrade steps for CMS 2.5 to 4.0                                ##
##                                                                                                          ##
##############################################################################################################


#Amit Seth <amit.seth@ericsson.com>
# migrate_alerts.sh is the one that needs to be called. It will internally call migrate_alerts_to_yaml.py and create the alerts.yaml file.
# Script requires an additional package 'python-psycopg2', which is available in the red hat repo and will need to be installed before the execution of the script.

if [[ -z `rpm -qa | grep python-psycopg2` ]] ; then 
    echo "Missing required RPM python-psycopg2"
    exit 1
fi
    
if [[ -f migrate_alerts/migrate_alerts.sh ]] ; then
    cd migrate_alerts
    bash migrate_alerts.sh
fi

#Remove jboss link
if [[ -d /opt/tandbergtv/cms/jboss ]] ; then
    echo "Removing Link /opt/tandbergtv/cms/jboss"
    rm -f /opt/tandbergtv/cms/jboss
fi
