#!/bin/bash

##################################################################
# Migrating the following entities from 3.0 to 3.1.010
# custom fields, content class, and definition.xml
##################################################################
## Back up 2.5 files ##
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/definition.xml "$backupdir/"
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/ecmf.properties "$backupdir/"
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_definition.xml "$backupdir/"
cp /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources/series_ecmf.properties "$backupdir/"

RESOURCE_DIR="/opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources"

cd ./customfields
ACTIVITY="upgrading custom fields"
logBeginMsg "begin $ACTIVITY"
DEF_FILE="$RESOURCE_DIR/definition.xml"
SERIES_FILE="$RESOURCE_DIR/series_definition.xml"
ECMF_FILE="$RESOURCE_DIR/ecmf.properties"
./scripts/cf_upgrade_config.sh "$DEF_FILE $SERIES_FILE $ECMF_FILE"
./scripts/custom_fields_upgrade.sh
logDoneMsg "$ACTIVITY"


ACTIVITY="upgrading Content Class Partner Override"
logBeginMsg "begin $ACTIVITY"
./scripts/content_class_partner_upgrade.sh
logDoneMsg "$ACTIVITY"


## Copy upgraded definition.xml
cp "$upgradedir/definition.xml" "$RESOURCE_DIR/"
cp "$upgradedir/ecmf.properties" "$RESOURCE_DIR/"
cp "$upgradedir/series_definition.xml" "$RESOURCE_DIR/"
cp "$upgradedir/series_ecmf.properties" "$RESOURCE_DIR/"

# Force change ownership of all to nobody
chown -R nobody:nobody /opt/tandbergtv/
chown -R nobody:nobody /usr/local/n2bb
