/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.hibernate.GetOptionsWork;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.content.contentclass.service.TitlesAssociatedException;
import com.tandbergtv.content.contentclass.util.ContentClassIngestMerger;
import com.tandbergtv.content.contentclass.util.ContentClassTitleBuilder;
import com.tandbergtv.content.contentclass.util.ContentClassUIMerger;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate
implements IContentClassService {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);

    @Transactional
    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException {
        return (Date)ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody1$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassLastUpdateDate", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException {
        return (Map)ContentClassServiceHibernate.getFieldsWithOptions_aroundBody3$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getFieldsWithOptions", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        return (List)ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody5$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getAllContentClassesWithoutMetadata", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException {
        return (List)ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody7$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getAllContentClassPartnersWithoutMetadata", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long partnerId) throws ContentClassPersistenceException {
        long l = partnerId;
        return (List)ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody9$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getPartnerContentClassesWithoutMetadata", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    private List<ContentClass> createContentClassList(List tmpList) {
        if (tmpList == null) {
            return null;
        }
        ArrayList<ContentClass> list = new ArrayList<ContentClass>();
        for (int i = 0; i < tmpList.size(); ++i) {
            Object[] data = (Object[])tmpList.get(i);
            ContentClass cc = new ContentClass();
            cc.setId(((Long)data[0]).longValue());
            int typeId = (Integer)data[1];
            switch (typeId) {
                case 0: {
                    cc.setType(ContentClass.Type.Package);
                    break;
                }
                case 1: {
                    cc.setType(ContentClass.Type.Series);
                    break;
                }
                case 2: {
                    cc.setType(ContentClass.Type.Category);
                    break;
                }
                default: {
                    cc.setType(ContentClass.Type.Package);
                }
            }
            cc.setName((String)data[2]);
            cc.setDescription((String)data[3]);
            int specialUsageId = (Integer)data[4];
            switch (specialUsageId) {
                case 1: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    cc.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            cc.setDefault(((Boolean)data[5]).booleanValue());
            list.add(cc);
        }
        return list;
    }

    @Transactional
    public ContentClass getContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        return (ContentClass)ContentClassServiceHibernate.getContentClassById_aroundBody11$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassById", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        ContentClass contentClass2 = contentClass;
        ContentClassServiceHibernate.saveContentClass_aroundBody13$advice(this, contentClass2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClass", ContentClass.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassById(long id) throws ContentClassPersistenceException {
        long l = id;
        ContentClassServiceHibernate.deleteContentClassById_aroundBody15$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassById", Long.TYPE).getAnnotation(Transactional.class), null);
    }

    public String getServiceName() {
        return "ContentClassService";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public ContentClassPartner getContentClassPartner(long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        boolean bl = enforceCCPartnerAssociation;
        return (ContentClassPartner)ContentClassServiceHibernate.getContentClassPartner_aroundBody17$advice(this, l, l2, bl, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartner", Long.TYPE, Long.TYPE, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    public ContentClassPartner getContentClassPartnerMetadata(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        try {
            Object ccp = null;
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                return null;
            }
            session.evict((Object)entity);
            return ContentClassHibernateFactory.createContentClassPartner(entity);
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner with contentClassId = " + contentClassId + "and partnerId = " + partnerId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    @Transactional
    public void saveContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        ContentClassServiceHibernate.saveContentClassPartner_aroundBody19$advice(this, contentClassPartner, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("saveContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassPartner(ContentClassPartner ccp) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = ccp;
        ContentClassServiceHibernate.deleteContentClassPartner_aroundBody21$advice(this, contentClassPartner, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassPartner", ContentClassPartner.class).getAnnotation(Transactional.class), null);
    }

    private boolean isSelfPartner(String userName) throws Exception {
        String sql = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.setString(0, userName);
        query.addScalar("cnt", (Type)Hibernate.INTEGER);
        int count = (Integer)query.uniqueResult();
        return count > 0;
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        String string = userName;
        return (Map)ContentClassServiceHibernate.getContentClassPartnerMap_aroundBody23$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnerMap", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String userName) throws ContentClassPersistenceException {
        String string = userName;
        return (Map)ContentClassServiceHibernate.getCategoryContentClassPartnerMap_aroundBody25$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getCategoryContentClassPartnerMap", String.class).getAnnotation(Transactional.class), null);
    }

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String userName, boolean categoryContentClassOnly) throws ContentClassPersistenceException {
        HashMap<Long, ContentClassPartnerList> map = new HashMap<Long, ContentClassPartnerList>();
        try {
            SQLQuery query;
            String sql;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (this.isSelfPartner(userName)) {
                sql = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1 and p.partnertype in (0,2)";
                if (categoryContentClassOnly) {
                    sql = sql + " and c.content_class_type_id = 2";
                }
                query = session.createSQLQuery(sql);
            } else {
                sql = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id and p.isactive = 1 and p.partnertype in (0,2) and u.username = ?";
                if (categoryContentClassOnly) {
                    sql = sql + " and c.content_class_type_id = 2";
                }
                query = session.createSQLQuery(sql);
                query.setString(0, userName);
            }
            query.addScalar("pid", (Type)Hibernate.LONG);
            query.addScalar("pname", (Type)Hibernate.STRING);
            query.addScalar("cid", (Type)Hibernate.LONG);
            query.addScalar("cname", (Type)Hibernate.STRING);
            query.addScalar("ctype", (Type)Hibernate.INTEGER);
            List results = query.list();
            if (results != null && !results.isEmpty()) {
                for (Object result : results) {
                    Object[] data = (Object[])result;
                    Long partnerId = (Long)data[0];
                    String partnerName = (String)data[1];
                    Long ccId = (Long)data[2];
                    String ccName = (String)data[3];
                    Integer ccType = (Integer)data[4];
                    ContentClassPartnerList ccpList = (ContentClassPartnerList)map.get(partnerId);
                    if (ccpList == null) {
                        ccpList = new ContentClassPartnerList(partnerId.longValue());
                        ccpList.setPartnerName(partnerName);
                        map.put(partnerId, ccpList);
                    }
                    ccpList.addContentClass(ccId.longValue(), ccName, ccType.intValue());
                }
            }
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner map";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return map;
    }

    @Transactional
    public Long getContentClassIdByName(String name) throws ContentClassPersistenceException {
        String string = name;
        return (Long)ContentClassServiceHibernate.getContentClassIdByName_aroundBody27$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassIdByName", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getDefaultContentClassId() throws ContentClassPersistenceException {
        return (Long)ContentClassServiceHibernate.getDefaultContentClassId_aroundBody29$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getDefaultContentClassId", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getCategoryContentClassId() throws ContentClassPersistenceException {
        return (Long)ContentClassServiceHibernate.getCategoryContentClassId_aroundBody31$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getCategoryContentClassId", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public Long getSeriesContentClassId() throws ContentClassPersistenceException {
        return (Long)ContentClassServiceHibernate.getSeriesContentClassId_aroundBody33$advice(this, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getSeriesContentClassId", new Class[0]).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        return (ContentClassPartner)ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody35$advice(this, l, l2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getMergedContentClassPartnerMetadataForIngest", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        long l = contentClassId;
        long l2 = partnerId;
        return (ContentClassPartner)ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody37$advice(this, l, l2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getMergedContentClassPartnerMetadataForView", Long.TYPE, Long.TYPE).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void deleteContentClassesById(Collection<Long> ids) throws ContentClassPersistenceException {
        Collection<Long> collection = ids;
        ContentClassServiceHibernate.deleteContentClassesById_aroundBody39$advice(this, collection, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("deleteContentClassesById", Collection.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void applyContentClassMetadataForIngest(Title title) throws ContentClassPersistenceException {
        Title title2 = title;
        ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody41$advice(this, title2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("applyContentClassMetadataForIngest", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public void applyContentClassMetadataForView(Title title) throws ContentClassPersistenceException {
        Title title2 = title;
        ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody43$advice(this, title2, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("applyContentClassMetadataForView", Title.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public boolean contentClassNameExists(String name) throws ContentClassPersistenceException {
        String string = name;
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.contentClassNameExists_aroundBody45$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("contentClassNameExists", String.class).getAnnotation(Transactional.class), null));
    }

    public boolean contentClassAssociatedWithTitle(long contentClassId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_title where content_class_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    public boolean contentClassPartnerExists(long contentClassId, long partnerId) throws ContentClassPersistenceException {
        String sql = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ? and partner_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    @Transactional
    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long contentClassId, boolean fetchMetadata) throws ContentClassPersistenceException {
        long l = contentClassId;
        boolean bl = fetchMetadata;
        return (List)ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody47$advice(this, l, bl, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getContentClassPartnersByContentClassId", Long.TYPE, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    public String marshalContentClass(ContentClass cc) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClass(cc, false);
    }

    public ContentClass unmarshalContentClass(String xml) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClass(xml);
    }

    public String marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.marshalContentClassWithPartners(cc, partners, false);
    }

    public ContentClass unmarshalContentClassWithPartners(String xml, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        ContentClassJaxbService service = new ContentClassJaxbService();
        return service.unmarshalContentClassWithPartners(xml, partners);
    }

    @Transactional
    public Long getPartnerIdByName(String name) throws ContentClassPersistenceException {
        String string = name;
        return (Long)ContentClassServiceHibernate.getPartnerIdByName_aroundBody49$advice(this, string, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("getPartnerIdByName", String.class).getAnnotation(Transactional.class), null);
    }

    @Transactional
    public boolean isCategoryPackage(long titleId) throws ContentClassPersistenceException {
        long l = titleId;
        return Conversions.booleanValue((Object)ContentClassServiceHibernate.isCategoryPackage_aroundBody51$advice(this, l, TransactionEnforcer.aspectOf(), ContentClassServiceHibernate.class.getDeclaredMethod("isCategoryPackage", Long.TYPE).getAnnotation(Transactional.class), null));
    }

    private static final /* synthetic */ Date getContentClassLastUpdateDate_aroundBody0(ContentClassServiceHibernate this_) {
        String queryStr = "select max(updatedate) as updatedate from PMM_CONTENT_CLASS";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryStr);
        query.addScalar("updatedate", (Type)new TimestampType());
        Date d = (Date)query.uniqueResult();
        return d;
    }

    private static final /* synthetic */ Object getContentClassLastUpdateDate_aroundBody1$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody0(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Date object = ContentClassServiceHibernate.getContentClassLastUpdateDate_aroundBody0(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Map getFieldsWithOptions_aroundBody2(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            GetOptionsWork work = new GetOptionsWork();
            session.doWork((Work)work);
            return work.getFieldsWithOptions();
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content classes";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getFieldsWithOptions_aroundBody3$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getFieldsWithOptions_aroundBody2(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = ContentClassServiceHibernate.getFieldsWithOptions_aroundBody2(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllContentClassesWithoutMetadata_aroundBody4(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id, typeId, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(sql);
            List tmpList = query.list();
            if (tmpList == null || tmpList.isEmpty()) {
                return null;
            }
            return this_.createContentClassList(tmpList);
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content classes";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getAllContentClassesWithoutMetadata_aroundBody5$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody4(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getAllContentClassesWithoutMetadata_aroundBody4(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getAllContentClassPartnersWithoutMetadata_aroundBody6(ContentClassServiceHibernate this_) {
        ArrayList<ContentClassPartner> partnerList = new ArrayList<ContentClassPartner>();
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select content_class_id, partner_id from pmm_content_class_partner";
            SQLQuery query = session.createSQLQuery(sql);
            query.addScalar("content_class_id", (Type)Hibernate.LONG);
            query.addScalar("partner_id", (Type)Hibernate.LONG);
            List results = query.list();
            if (results != null && !results.isEmpty()) {
                for (Object result : results) {
                    Object[] data = (Object[])result;
                    ContentClassPartner ccp = new ContentClassPartner(((Long)data[0]).longValue(), ((Long)data[1]).longValue());
                    partnerList.add(ccp);
                }
            }
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content class partners";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
        return partnerList;
    }

    private static final /* synthetic */ Object getAllContentClassPartnersWithoutMetadata_aroundBody7$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody6(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getAllContentClassPartnersWithoutMetadata_aroundBody6(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getPartnerContentClassesWithoutMetadata_aroundBody8(ContentClassServiceHibernate this_, long partnerId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select c.id, c.typeId, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
            Query query = session.createQuery(sql);
            query.setLong(0, partnerId);
            List tmpList = query.list();
            if (tmpList == null || tmpList.isEmpty()) {
                return null;
            }
            return this_.createContentClassList(tmpList);
        }
        catch (Exception ex) {
            String msg = "Unable to get a list of content classes";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getPartnerContentClassesWithoutMetadata_aroundBody9$advice(ContentClassServiceHibernate this_, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody8(this_, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getPartnerContentClassesWithoutMetadata_aroundBody8(this_, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClass getContentClassById_aroundBody10(ContentClassServiceHibernate this_, long id) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(id));
            if (cch == null) {
                String msg = "Content class with id = " + id + " doesn't exist";
                throw new ContentClassPersistenceException(msg);
            }
            session.evict((Object)cch);
            return ContentClassHibernateFactory.createContentClass(cch);
        }
        catch (Exception ex) {
            String msg = "Unable to get a content classes with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassById_aroundBody11$advice(ContentClassServiceHibernate this_, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassById_aroundBody10(this_, id);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClass object = ContentClassServiceHibernate.getContentClassById_aroundBody10(this_, id);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveContentClass_aroundBody12(ContentClassServiceHibernate this_, ContentClass contentClass) {
        if (contentClass == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity cch = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            session.saveOrUpdate((Object)cch);
            contentClass.setId(cch.id);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object saveContentClass_aroundBody13$advice(ContentClassServiceHibernate this_, ContentClass contentClass, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody12(this_, contentClass);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClass_aroundBody12(this_, contentClass);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassById_aroundBody14(ContentClassServiceHibernate this_, long id) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery("delete from pmm_content_class where id = ?");
            query.setLong(0, id);
            query.executeUpdate();
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class with id = " + id;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassById_aroundBody15$advice(ContentClassServiceHibernate this_, long id, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody14(this_, id);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassById_aroundBody14(this_, id);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getContentClassPartner_aroundBody16(ContentClassServiceHibernate this_, long contentClassId, long partnerId, boolean enforceCCPartnerAssociation) {
        try {
            ContentClassPartner ccp = null;
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(contentClassId, partnerId);
            entity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)entity);
            if (entity == null) {
                if (enforceCCPartnerAssociation) {
                    throw new ContentClassPersistenceException("Content class " + contentClassId + " and partner " + partnerId + " are not associated.");
                }
                ccp = new ContentClassPartner(contentClassId, partnerId);
            } else {
                ccp = ContentClassHibernateFactory.createContentClassPartner(entity);
            }
            String SQL = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ? and p.id_ = ?";
            SQLQuery query = session.createSQLQuery(SQL);
            query.setLong(0, contentClassId);
            query.setLong(1, partnerId);
            Object[] result = (Object[])query.uniqueResult();
            if (result == null) {
                throw new ContentClassPersistenceException("Invalid content class " + contentClassId + " or partner " + partnerId);
            }
            ccp.setContentClassName((String)result[0]);
            ccp.setPartnerName((String)result[1]);
            ccp.setProviderId((String)result[2]);
            return ccp;
        }
        catch (ContentClassPersistenceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partner with contentClassId = " + contentClassId + "and partnerId = " + partnerId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassPartner_aroundBody17$advice(ContentClassServiceHibernate this_, long contentClassId, long partnerId, boolean unknown4, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartner_aroundBody16(this_, contentClassId, partnerId, unknown4);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getContentClassPartner_aroundBody16(this_, contentClassId, partnerId, unknown4);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveContentClassPartner_aroundBody18(ContentClassServiceHibernate this_, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = ContentClassHibernateFactory.createContentClassPartnerEntity(ccp);
            session.saveOrUpdate((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to save a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object saveContentClassPartner_aroundBody19$advice(ContentClassServiceHibernate this_, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody18(this_, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.saveContentClassPartner_aroundBody18(this_, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassPartner_aroundBody20(ContentClassServiceHibernate this_, ContentClassPartner ccp) {
        if (ccp == null) {
            return;
        }
        boolean titlesFound = false;
        try {
            String sql = "select id_ from pmm_title where content_class_id = ? and partner_id = ? and titlestatusid <> 5";
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, ccp.getContentClassId());
            query.setLong(1, ccp.getPartnerId());
            query.addScalar("id_", (Type)Hibernate.LONG);
            query.setMaxResults(1);
            titlesFound = query.uniqueResult() != null;
        }
        catch (Exception ex) {
            String message = "Unable to check if there are titles created with content class [" + ccp.getContentClassId() + "] for partner [" + ccp.getPartnerId() + "]";
            logger.error((Object)message, (Throwable)ex);
            throw new ContentClassPersistenceException(message, (Throwable)ex);
        }
        if (titlesFound) {
            throw new TitlesAssociatedException("There are titles in the system created with content class [" + ccp.getContentClassId() + "] for partner [" + ccp.getPartnerId() + "]");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity entity = new ContentClassPartnerEntity(ccp.getContentClassId(), ccp.getPartnerId());
            session.delete((Object)entity);
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class partner with contentClassId = " + ccp.getContentClassId() + "and partnerId = " + ccp.getPartnerId();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassPartner_aroundBody21$advice(ContentClassServiceHibernate this_, ContentClassPartner ccp, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody20(this_, ccp);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassPartner_aroundBody20(this_, ccp);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getContentClassPartnerMap_aroundBody23$advice(ContentClassServiceHibernate this_, String userName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.getContentClassPartnerMap(userName, false);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = this_.getContentClassPartnerMap(userName, false);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Object getCategoryContentClassPartnerMap_aroundBody25$advice(ContentClassServiceHibernate this_, String userName, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return this_.getContentClassPartnerMap(userName, true);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Map object = this_.getContentClassPartnerMap(userName, true);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getContentClassIdByName_aroundBody26(ContentClassServiceHibernate this_, String name) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where name = ?";
            Query query = session.createQuery(sql);
            query.setString(0, name);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get content class id by name " + name;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassIdByName_aroundBody27$advice(ContentClassServiceHibernate this_, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassIdByName_aroundBody26(this_, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getContentClassIdByName_aroundBody26(this_, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getDefaultContentClassId_aroundBody28(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where isDefault = 1";
            Query query = session.createQuery(sql);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get default content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getDefaultContentClassId_aroundBody29$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getDefaultContentClassId_aroundBody28(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getDefaultContentClassId_aroundBody28(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getCategoryContentClassId_aroundBody30(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where typeId = 2";
            Query query = session.createQuery(sql);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get category content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getCategoryContentClassId_aroundBody31$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getCategoryContentClassId_aroundBody30(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getCategoryContentClassId_aroundBody30(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getSeriesContentClassId_aroundBody32(ContentClassServiceHibernate this_) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id from ContentClassEntity where typeId = 1";
            Query query = session.createQuery(sql);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get category content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getSeriesContentClassId_aroundBody33$advice(ContentClassServiceHibernate this_, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getSeriesContentClassId_aroundBody32(this_);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getSeriesContentClassId_aroundBody32(this_);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getMergedContentClassPartnerMetadataForIngest_aroundBody34(ContentClassServiceHibernate this_, long contentClassId, long partnerId) {
        ContentClass cc = this_.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException("Content class with id " + contentClassId + " doesn't exist.");
        }
        ContentClassPartner ccp = this_.getContentClassPartner(contentClassId, partnerId, true);
        if (ccp == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + partnerId + ", contentClassId = " + contentClassId);
        }
        ccp.setContentClassType(cc.getType());
        ContentClassIngestMerger merger = new ContentClassIngestMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    private static final /* synthetic */ Object getMergedContentClassPartnerMetadataForIngest_aroundBody35$advice(ContentClassServiceHibernate this_, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody34(this_, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForIngest_aroundBody34(this_, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContentClassPartner getMergedContentClassPartnerMetadataForView_aroundBody36(ContentClassServiceHibernate this_, long contentClassId, long partnerId) {
        ContentClass cc = this_.getContentClassById(contentClassId);
        if (cc == null) {
            throw new ContentClassPersistenceException("Content class with id " + contentClassId + " doesn't exist.");
        }
        ContentClassPartner ccp = null;
        ccp = this_.getContentClassPartner(contentClassId, partnerId, false);
        if (ccp == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + partnerId + ", contentClassId = " + contentClassId);
        }
        ccp.setContentClassType(cc.getType());
        ContentClassUIMerger merger = new ContentClassUIMerger();
        ContentClassMetadata mergedMetadata = merger.mergeMetadata(cc, ccp);
        ccp.setMetadata(mergedMetadata);
        return ccp;
    }

    private static final /* synthetic */ Object getMergedContentClassPartnerMetadataForView_aroundBody37$advice(ContentClassServiceHibernate this_, long contentClassId, long partnerId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody36(this_, contentClassId, partnerId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassPartner object = ContentClassServiceHibernate.getMergedContentClassPartnerMetadataForView_aroundBody36(this_, contentClassId, partnerId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContentClassesById_aroundBody38(ContentClassServiceHibernate this_, Collection ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        long gId = 0L;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery("delete from pmm_content_class where id = ?");
            for (Long id : ids) {
                gId = id;
                query.setLong(0, id.longValue());
                query.executeUpdate();
            }
        }
        catch (Exception ex) {
            String msg = "Unable to delete a content class with id = " + gId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object deleteContentClassesById_aroundBody39$advice(ContentClassServiceHibernate this_, Collection ids, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody38(this_, ids);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.deleteContentClassesById_aroundBody38(this_, ids);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void applyContentClassMetadataForIngest_aroundBody40(ContentClassServiceHibernate this_, Title title) {
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            throw new ContentClassPersistenceException("Content Class ID is null");
        }
        String path = title.getAsset().getPath();
        if (path != null && path.equalsIgnoreCase("Series") && contentClassId != 2L) {
            throw new ContentClassPersistenceException("Cannot create Series title with non-series Content Class");
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            throw new ContentClassPersistenceException("Partner ID is null");
        }
        ContentClassPartner ccp = this_.getMergedContentClassPartnerMetadataForIngest(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder();
        builder.applyMetadata(title, ccp);
    }

    private static final /* synthetic */ Object applyContentClassMetadataForIngest_aroundBody41$advice(ContentClassServiceHibernate this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody40(this_, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForIngest_aroundBody40(this_, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void applyContentClassMetadataForView_aroundBody42(ContentClassServiceHibernate this_, Title title) {
        if (title == null) {
            return;
        }
        Long contentClassId = title.getContentClassId();
        if (contentClassId == null || contentClassId == 0L) {
            throw new ContentClassPersistenceException("Content Class ID is null");
        }
        Long partnerId = title.getPartnerId();
        if (partnerId == null || partnerId == 0L) {
            throw new ContentClassPersistenceException("Partner ID is null");
        }
        ContentClassPartner ccp = this_.getMergedContentClassPartnerMetadataForView(contentClassId, partnerId);
        ContentClassTitleBuilder builder = new ContentClassTitleBuilder(true);
        builder.applyMetadata(title, ccp);
    }

    private static final /* synthetic */ Object applyContentClassMetadataForView_aroundBody43$advice(ContentClassServiceHibernate this_, Title title, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody42(this_, title);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContentClassServiceHibernate.applyContentClassMetadataForView_aroundBody42(this_, title);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean contentClassNameExists_aroundBody44(ContentClassServiceHibernate this_, String name) {
        String sql = "select count(*) as cnt from pmm_content_class where name = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery query = session.createSQLQuery(sql);
            query.setString(0, name);
            query.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer count = (Integer)query.uniqueResult();
            return count > 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to check if content class name exists", (Throwable)ex);
            throw new ContentClassPersistenceException((Throwable)ex);
        }
    }

    private static final /* synthetic */ Object contentClassNameExists_aroundBody45$advice(ContentClassServiceHibernate this_, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassNameExists_aroundBody44(this_, name));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.contentClassNameExists_aroundBody44(this_, name));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ List getContentClassPartnersByContentClassId_aroundBody46(ContentClassServiceHibernate this_, long contentClassId, boolean fetchMetadata) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = fetchMetadata ? "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid, ccp.data from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?" : "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?";
            SQLQuery query = session.createSQLQuery(sql);
            query.setLong(0, contentClassId);
            List results = query.list();
            if (results == null || results.isEmpty()) {
                return null;
            }
            ContentClassJaxbService jaxbService = new ContentClassJaxbService();
            ArrayList<ContentClassPartner> partners = new ArrayList<ContentClassPartner>();
            for (Object result : results) {
                Clob clob;
                Object[] field = (Object[])result;
                ContentClassPartner ccp = new ContentClassPartner();
                ccp.setContentClassId(contentClassId);
                ccp.setContentClassName((String)field[0]);
                BigDecimal bd = (BigDecimal)field[1];
                if (bd != null) {
                    ccp.setPartnerId(bd.longValue());
                }
                ccp.setPartnerName((String)field[2]);
                ccp.setProviderId((String)field[3]);
                if (fetchMetadata && (clob = (Clob)field[4]) != null) {
                    Reader reader = clob.getCharacterStream();
                    try {
                        ContentClassMetadata metadata = jaxbService.unmarshalContentClassMetadata(reader);
                        ccp.setMetadata(metadata);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                partners.add(ccp);
            }
            return partners;
        }
        catch (Exception ex) {
            String msg = "Unable to get content class partners with contentClassId = " + contentClassId;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getContentClassPartnersByContentClassId_aroundBody47$advice(ContentClassServiceHibernate this_, long contentClassId, boolean fetchMetadata, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody46(this_, contentClassId, fetchMetadata);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContentClassServiceHibernate.getContentClassPartnersByContentClassId_aroundBody46(this_, contentClassId, fetchMetadata);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Long getPartnerIdByName_aroundBody48(ContentClassServiceHibernate this_, String name) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "select id_ as id from pmm_partner where name = ? and isactive = 1";
            SQLQuery query = session.createSQLQuery(sql);
            query.addScalar("id", (Type)Hibernate.LONG);
            query.setString(0, name);
            return (Long)query.uniqueResult();
        }
        catch (Exception ex) {
            String msg = "Unable to get partner id by name " + name;
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object getPartnerIdByName_aroundBody49$advice(ContentClassServiceHibernate this_, String name, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContentClassServiceHibernate.getPartnerIdByName_aroundBody48(this_, name);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Long object = ContentClassServiceHibernate.getPartnerIdByName_aroundBody48(this_, name);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ boolean isCategoryPackage_aroundBody50(ContentClassServiceHibernate this_, long titleId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String sql = "SELECT content_class_id FROM pmm_title WHERE id_ = " + titleId;
            SQLQuery query = session.createSQLQuery(sql);
            Object result1 = query.uniqueResult();
            if (result1 == null) {
                throw new ContentClassPersistenceException("No record found for titleId " + titleId);
            }
            Long contentClassId1 = ((BigDecimal)result1).longValue();
            Long contentClassId2 = this_.getCategoryContentClassId();
            return contentClassId1.longValue() == contentClassId2.longValue();
        }
        catch (ContentClassPersistenceException ccpe) {
            logger.error((Object)"Failed to determine if the title is a category package", (Throwable)ccpe);
            throw ccpe;
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to determine if the title is a category package", (Throwable)ex);
            throw new ContentClassPersistenceException("Failed to determine if the title is a category package", (Throwable)ex);
        }
    }

    private static final /* synthetic */ Object isCategoryPackage_aroundBody51$advice(ContentClassServiceHibernate this_, long titleId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return Conversions.booleanObject((boolean)ContentClassServiceHibernate.isCategoryPackage_aroundBody50(this_, titleId));
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Object object = Conversions.booleanObject((boolean)ContentClassServiceHibernate.isCategoryPackage_aroundBody50(this_, titleId));
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

