/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.jaxb;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbFactory;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassType;
import com.tandbergtv.content.contentclass.jaxb.model.MetadataType;
import com.tandbergtv.content.contentclass.jaxb.model.ObjectFactory;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class ContentClassJaxbService {
    private final String JAXB_CONTEXT_PATH = "com.tandbergtv.content.contentclass.jaxb.model";
    private static Logger logger = Logger.getLogger(ContentClassJaxbService.class);

    public String marshalContentClass(ContentClass cc, boolean formatOutput) throws ContentClassPersistenceException {
        if (cc == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalContentClass(cc, writer, formatOutput);
        return writer.toString();
    }

    public void marshalContentClass(ContentClass cc, Writer writer) throws ContentClassPersistenceException {
        this.marshalContentClass(cc, writer, false);
    }

    public void marshalContentClass(ContentClass cc, Writer writer, boolean formatOutput) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            ContentClassType type = jaxbFactory.createContentClassType(cc);
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<ContentClassType> root = factory.createContentClass(type);
            Marshaller mar = this.createMarshaller(formatOutput);
            mar.marshal(root, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public void marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners, Writer writer, boolean formatOutput) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            ContentClassType type = jaxbFactory.createContentClassTypeWithPartners(cc, partners);
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<ContentClassType> root = factory.createContentClass(type);
            Marshaller mar = this.createMarshaller(formatOutput);
            mar.marshal(root, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public String marshalContentClassWithPartners(ContentClass cc, List<ContentClassPartner> partners, boolean formatOutput) throws ContentClassPersistenceException {
        if (cc == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalContentClassWithPartners(cc, partners, writer, formatOutput);
        return writer.toString();
    }

    public ContentClass unmarshalContentClassWithPartners(Reader reader, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        try {
            Unmarshaller umar = this.createUnmarshaller();
            JAXBElement root = (JAXBElement)umar.unmarshal(reader);
            ContentClassType type = (ContentClassType)root.getValue();
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            ContentClass cc = jaxbFactory.createContentClass(type);
            if (cc == null) {
                return null;
            }
            List<ContentClassPartnerType> pTypeList = null;
            if (type.getPartners() != null) {
                pTypeList = type.getPartners().getPartner();
            }
            if (partners != null && pTypeList != null) {
                partners.clear();
                for (ContentClassPartnerType pType : pTypeList) {
                    ContentClassPartner ccp = jaxbFactory.createContentClassPartner(pType);
                    ccp.setContentClassName(cc.getName());
                    partners.add(ccp);
                }
            }
            return cc;
        }
        catch (Exception ex) {
            String msg = "Unable to unmarshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public ContentClass unmarshalContentClassWithPartners(String xml, List<ContentClassPartner> partners) throws ContentClassPersistenceException {
        if (xml == null) {
            return null;
        }
        StringReader reader = new StringReader(xml);
        return this.unmarshalContentClassWithPartners(reader, partners);
    }

    public void marshalContentClassMetadata(ContentClassMetadata metadata, Writer writer) throws ContentClassPersistenceException {
        this.marshalContentClassMetadata(metadata, writer, false);
    }

    public void marshalContentClassMetadata(ContentClassMetadata ccMetadata, Writer writer, boolean formatOutput) throws ContentClassPersistenceException {
        try {
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            MetadataType metadata = jaxbFactory.createMetadataType(ccMetadata);
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<MetadataType> root = factory.createMetadata(metadata);
            Marshaller mar = this.createMarshaller(formatOutput);
            mar.marshal(root, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public String marshalContentClassMetadata(ContentClassMetadata ccMetadata, boolean formatOutput) throws ContentClassPersistenceException {
        if (ccMetadata == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalContentClassMetadata(ccMetadata, writer, formatOutput);
        return writer.toString();
    }

    public String marshalContentClassMetadata(ContentClassMetadata ccMetadata) throws ContentClassPersistenceException {
        return this.marshalContentClassMetadata(ccMetadata, false);
    }

    public ContentClass unmarshalContentClass(Reader reader) throws ContentClassPersistenceException {
        try {
            Unmarshaller umar = this.createUnmarshaller();
            JAXBElement root = (JAXBElement)umar.unmarshal(reader);
            ContentClassType metadata = (ContentClassType)root.getValue();
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            return jaxbFactory.createContentClass(metadata);
        }
        catch (Exception ex) {
            String msg = "Unable to unmarshal content class: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public ContentClass unmarshalContentClass(String xml) throws ContentClassPersistenceException {
        if (xml == null) {
            return null;
        }
        StringReader reader = new StringReader(xml);
        return this.unmarshalContentClass(reader);
    }

    public ContentClassMetadata unmarshalContentClassMetadata(Reader reader) throws ContentClassPersistenceException {
        try {
            Unmarshaller umar = this.createUnmarshaller();
            JAXBElement root = (JAXBElement)umar.unmarshal(reader);
            MetadataType metadata = (MetadataType)root.getValue();
            ContentClassJaxbFactory jaxbFactory = new ContentClassJaxbFactory();
            return jaxbFactory.createContentClassMetadata(metadata);
        }
        catch (Exception ex) {
            String msg = "Unable to unmarshal content class";
            logger.error((Object)msg, (Throwable)ex);
            throw new ContentClassPersistenceException(msg, (Throwable)ex);
        }
    }

    public ContentClassMetadata unmarshalContentClassMetadata(String xml) throws ContentClassPersistenceException {
        if (xml == null) {
            return null;
        }
        StringReader reader = new StringReader(xml);
        return this.unmarshalContentClassMetadata(reader);
    }

    private Marshaller createMarshaller(boolean formatOutput) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
        Marshaller mar = jc.createMarshaller();
        if (formatOutput) {
            mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        return mar;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.tandbergtv.content.contentclass.jaxb.model");
        return jc.createUnmarshaller();
    }
}

