/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleProxy;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public class GetUnapprovedSchedulesMessageHandler
implements MessageHandler {
    private static final String CONTEXT_ID_PARAM = "contextId";
    private static final String START_DATE_PARAM = "startDate";
    private static final String DAYS_AFTER_PARAM = "daysAfter";
    private static final String SCHEDULE_IDS_PARAM = "scheduleIds";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String SEARCH_DATE_FORMAT = "yyyy-MM-dd";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws MessageHandlerException {
        long contextId = this.getLongParameter(message, CONTEXT_ID_PARAM);
        Date startDate = this.getDateParameter(message, START_DATE_PARAM);
        int daysAfter = (int)this.getLongParameter(message, DAYS_AFTER_PARAM);
        if (daysAfter < 0) {
            String msg = "The daysAfter message parameter must have a number value greater than or equal to 0, got value: " + daysAfter;
            throw new MessageHandlerException(msg);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, daysAfter);
        Date endDate = calendar.getTime();
        ServiceRegistry registry = ServiceRegistry.getDefault();
        IScheduleSearchService service = (IScheduleSearchService)registry.lookup(IScheduleSearchService.class);
        SearchCriteria criteria = this.buildSearchCriteria(contextId, startDate, endDate);
        Collection schedules = service.search(criteria);
        String scheduleIds = this.getUnapprovedScheduleIds(schedules);
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(SCHEDULE_IDS_PARAM, scheduleIds);
        return response;
    }

    private SearchCriteria buildSearchCriteria(long contextId, Date startDate, Date endDate) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("list", ScheduleProxy.class, "s");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        range.setFrom(format.format(startDate));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.add(5, -1);
        Date modifiedEndDate = calendar.getTime();
        range.setTo(format.format(modifiedEndDate));
        e.addParameter((SearchParameterBase)range);
        int pitchType = TitleListType.PITCH.ordinal();
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.TITLE_LIST_TYPE.toString(), SearchType.NUMERIC, (Object)pitchType));
        criteria.addParameter((SearchParameterBase)e);
        return criteria;
    }

    private String getUnapprovedScheduleIds(Collection<? extends Schedule> schedules) throws MessageHandlerException {
        StringBuilder result = new StringBuilder();
        if (schedules == null) {
            schedules = new ArrayList<Schedule>();
        }
        for (Schedule schedule : schedules) {
            if (schedule.getStatus() == ScheduleStatus.APPROVED) continue;
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(schedule.getId());
        }
        return result.toString();
    }

    private long getLongParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        long result = 0L;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a number value was expected.");
        }
        try {
            result = Long.parseLong(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid number value, received value: " + value, e);
        }
        return result;
    }

    private Date getDateParameter(WorkflowMessage message, String name) throws MessageHandlerException {
        String value;
        Date result = null;
        String string = value = message.getPayload() != null ? message.getValue(name) : null;
        if (value == null || value.trim().length() == 0) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter is blank / missing when a date value was expected.");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            result = format.parse(value);
        }
        catch (Exception e) {
            throw new MessageHandlerException("ERR-002", "The " + name + " message parameter does not have a valid date value. Expected format: " + "yyyy-MM-dd" + ", received value: " + value, e);
        }
        return result;
    }
}

