/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.util.ContainerCache;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import org.apache.log4j.Logger;

public class ContainerCacheActivator {
    private static final Logger logger = Logger.getLogger(ContainerCacheActivator.class);

    public void start() {
        try {
            ICacheService<IContainer> containerCache = ContainerCache.getInstance();
            ServiceRegistry.getDefault().register(containerCache.getServiceName(), containerCache);
            containerCache.start();
            logger.debug((Object)"Starting container cache service.");
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error while starting container cache service: " + e.toString()));
        }
    }

    public void stop() {
        try {
            logger.debug((Object)"Stopping container cache service.");
            ServiceRegistry registry = ServiceRegistry.getDefault();
            Service service = registry.lookup("Container Cache");
            if (service != null) {
                service.stop();
                registry.unregister(service);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error while stopping container cache service: " + e.toString()));
        }
    }
}

