/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.upgrade;

import com.tandbergtv.cms.entity.CustomField;
import com.tandbergtv.cms.entity.CustomFieldGroup;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class UpgradeDBManager {
    private static SessionFactory sessionFactory;
    private static Logger logger;
    private List<CustomField> fieldsWithOptions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCustomFieldGroupsToCC() throws Exception {
        logger.info((Object)"Started save custom fields to Content Class");
        try {
            sessionFactory = new Configuration().configure("resources/hibernate.cfg.xml").buildSessionFactory();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        Session session = sessionFactory.openSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            List<CustomFieldGroup> list = this.getAllGroups((org.hibernate.Session)session);
            this.updateCCCustomFieldGroups(list, (org.hibernate.Session)session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
                throw exception;
            }
        }
        finally {
            session.close();
        }
    }

    private void updateCCCustomFieldGroups(List<CustomFieldGroup> list, org.hibernate.Session session) throws ContentClassPersistenceException {
        try {
            String string = "select id, typeId, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(string);
            List list2 = query.list();
            List<ContentClass> list3 = this.createContentClassList(list2);
            if (list3 != null) {
                for (ContentClass contentClass : list3) {
                    List<CustomFieldGroup> list4;
                    boolean bl;
                    ContentClassField contentClassField;
                    Collection collection;
                    ContentClassMetadata contentClassMetadata;
                    ContentClass contentClass2;
                    if (contentClass.getType() != ContentClass.Type.Series) {
                        contentClass2 = this.getContentClassById(contentClass.getId(), session);
                        if (contentClass2 == null) continue;
                        this.updateRemainingCF(contentClass2, list);
                        contentClassMetadata = contentClass2.getMetadata();
                        if (contentClassMetadata == null) {
                            contentClassMetadata = new ContentClassMetadata();
                            contentClass2.setMetadata(contentClassMetadata);
                        }
                        collection = contentClassMetadata.getAssetList();
                        for (ContentClassAsset contentClassAsset : collection) {
                            if (contentClassAsset == null || (contentClassField = contentClassAsset.getField("/Fields/CustomFields")) == null) continue;
                            bl = contentClassField.isEnabled();
                            contentClassAsset.removeField("/Fields/CustomFields");
                            list4 = this.getGroupsPerAsset(contentClassAsset, list);
                            for (CustomFieldGroup customFieldGroup : list4) {
                                this.addCCGroup(customFieldGroup, contentClassAsset, bl);
                            }
                        }
                        this.saveContentClass(contentClass2, session);
                        continue;
                    }
                    contentClass2 = this.getContentClassById(contentClass.getId(), session);
                    if (contentClass2 == null) continue;
                    this.updateRemainingCFSeries(contentClass2, list);
                    contentClassMetadata = contentClass2.getMetadata();
                    if (contentClassMetadata == null) {
                        contentClassMetadata = new ContentClassMetadata();
                        contentClass2.setMetadata(contentClassMetadata);
                    }
                    collection = contentClassMetadata.getAssetList();
                    for (ContentClassAsset contentClassAsset : collection) {
                        if (contentClassAsset == null || (contentClassField = contentClassAsset.getField("/Fields/CustomFields")) == null) continue;
                        bl = contentClassField.isEnabled();
                        contentClassAsset.removeField("/Fields/CustomFields");
                        list4 = this.getGroupsPerAssetSeries(contentClassAsset.getPath(), list);
                        for (CustomFieldGroup customFieldGroup : list4) {
                            this.addCCGroup(customFieldGroup, contentClassAsset, bl);
                        }
                    }
                    this.saveContentClass(contentClass2, session);
                }
            }
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            logger.error((Object)contentClassPersistenceException);
            throw new ContentClassPersistenceException((Throwable)contentClassPersistenceException);
        }
    }

    private void updateRemainingCFSeries(ContentClass contentClass, List<CustomFieldGroup> list) {
        Collection collection;
        ContentClassMetadata contentClassMetadata;
        if (contentClass != null && (contentClassMetadata = contentClass.getMetadata()) != null && (collection = contentClassMetadata.getAssetList()) != null) {
            for (ContentClassAsset contentClassAsset : collection) {
                List<CustomFieldGroup> list2 = this.getGroupsPerAssetSeries(contentClassAsset.getPath(), list);
                for (CustomFieldGroup customFieldGroup : list2) {
                    List<CustomField> list3 = customFieldGroup.getCustomFieldList();
                    if (list3 == null) continue;
                    for (CustomField customField : list3) {
                        ContentClassField contentClassField = contentClassAsset.getField(this.getFieldParentPath(customField));
                        ContentClassField contentClassField2 = contentClassAsset.getField(this.getFieldPath(customField));
                        if (contentClassField == null || contentClassField2 == null) continue;
                        if (contentClassField.isDisabled() || contentClassField2.isDisabled()) {
                            contentClassField2.setDisabled(Boolean.valueOf(true));
                        }
                        if (!customField.getMultiValue().equalsIgnoreCase("Y")) continue;
                        contentClassField2.setMax(contentClassField.getMax());
                        contentClassField2.setMin(contentClassField.getMin());
                    }
                }
            }
        }
    }

    private void updateRemainingCF(ContentClass contentClass, List<CustomFieldGroup> list) throws ContentClassPersistenceException {
        Collection collection;
        ContentClassMetadata contentClassMetadata;
        if (contentClass != null && (contentClassMetadata = contentClass.getMetadata()) != null && (collection = contentClassMetadata.getAssetList()) != null) {
            for (ContentClassAsset contentClassAsset : collection) {
                List<CustomField> list2 = this.getCustomFieldsPerAsset(contentClassAsset, list);
                if (list2 == null) continue;
                for (CustomField customField : list2) {
                    ContentClassField contentClassField = contentClassAsset.getField(this.getFieldParentPath(customField));
                    ContentClassField contentClassField2 = contentClassAsset.getField(this.getFieldPath(customField));
                    if (contentClassField == null || contentClassField2 == null) continue;
                    if (contentClassField.isDisabled() || contentClassField2.isDisabled()) {
                        contentClassField2.setDisabled(Boolean.valueOf(true));
                    }
                    if (!customField.getMultiValue().equalsIgnoreCase("Y")) continue;
                    contentClassField2.setMax(contentClassField.getMax());
                    contentClassField2.setMin(contentClassField.getMin());
                }
            }
        }
    }

    private String getFieldParentPath(CustomField customField) {
        String string = "/Fields/CustomFields/CustomField[@name=" + customField.getName() + "]";
        return string;
    }

    private List<CustomField> getCustomFieldsPerAsset(ContentClassAsset contentClassAsset, List<CustomFieldGroup> list) {
        String string = contentClassAsset.getPath();
        ArrayList<CustomField> arrayList = new ArrayList<CustomField>();
        for (CustomFieldGroup customFieldGroup : list) {
            if (!customFieldGroup.getAssetPath().equalsIgnoreCase(string)) continue;
            arrayList.addAll(customFieldGroup.getCustomFieldList());
        }
        return arrayList;
    }

    private void convertToSeriesPath(List<CustomFieldGroup> list) {
        if (list != null) {
            for (CustomFieldGroup customFieldGroup : list) {
                if (customFieldGroup.getAssetPath().equalsIgnoreCase("PACKAGE") || !customFieldGroup.getAssetPath().startsWith("PACKAGE")) continue;
                String string = customFieldGroup.getAssetPath().replaceAll("PACKAGE", "SERIES");
                customFieldGroup.setAssetPath(string);
            }
        }
    }

    private List<CustomFieldGroup> getGroupsPerAssetSeries(String string, List<CustomFieldGroup> list) {
        ArrayList<CustomFieldGroup> arrayList = new ArrayList<CustomFieldGroup>();
        String string2 = new String(string);
        if (!string2.equalsIgnoreCase("SERIES") && !string2.equalsIgnoreCase("SERIES/SEASON") && string2.startsWith("SERIES")) {
            string2 = string2.replaceAll("SERIES", "PACKAGE");
        }
        for (CustomFieldGroup customFieldGroup : list) {
            if (string2.equalsIgnoreCase("PACKAGE/SEASON/POSTER") && customFieldGroup.getAssetPath().equalsIgnoreCase("PACKAGE/POSTER")) {
                arrayList.add(customFieldGroup);
            }
            if (string2.equalsIgnoreCase("PACKAGE/SEASON/BOXCOVER") && customFieldGroup.getAssetPath().equalsIgnoreCase("PACKAGE/BOXCOVER")) {
                arrayList.add(customFieldGroup);
            }
            if (!customFieldGroup.getAssetPath().equalsIgnoreCase(string2)) continue;
            arrayList.add(customFieldGroup);
        }
        return arrayList;
    }

    private List<CustomFieldGroup> getGroupsPerAsset(ContentClassAsset contentClassAsset, List<CustomFieldGroup> list) {
        ArrayList<CustomFieldGroup> arrayList = new ArrayList<CustomFieldGroup>();
        String string = contentClassAsset.getPath();
        for (CustomFieldGroup customFieldGroup : list) {
            if (!customFieldGroup.getAssetPath().equalsIgnoreCase(string)) continue;
            arrayList.add(customFieldGroup);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCustomFieldGroups(CustomFieldGroup customFieldGroup) throws Exception {
        try {
            sessionFactory = new Configuration().configure("resources/hibernate.cfg.xml").buildSessionFactory();
            this.fieldsWithOptions = new ArrayList<CustomField>();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        Session session = sessionFactory.openSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            this.saveGroup(customFieldGroup, (org.hibernate.Session)session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
                throw exception;
            }
        }
        finally {
            session.close();
        }
    }

    private void saveGroup(CustomFieldGroup customFieldGroup, org.hibernate.Session session) throws Exception {
        List<CustomField> list = customFieldGroup.getCustomFieldList();
        if (!this.groupExists(customFieldGroup, session)) {
            session.save((Object)customFieldGroup);
            logger.info((Object)("Saved custom fields group " + customFieldGroup.getAssetPath()));
            if (list != null) {
                for (CustomField customField : list) {
                    if (!this.fieldExists(customField, session, customFieldGroup.getAssetPath())) {
                        session.save((Object)customField);
                        logger.info((Object)("Saved custom field  " + customField.getName()));
                        if (customField.getOptionList() == null || customField.getOptionList().isEmpty()) continue;
                        this.fieldsWithOptions.add(customField);
                        continue;
                    }
                    logger.info((Object)("Custom Field already exists, ignore: " + customField.getName() + " assetPath " + customFieldGroup.getAssetPath()));
                }
            }
        } else {
            logger.info((Object)("Custom Field Group already exists, ignore: " + customFieldGroup.getDisplayName() + " assetPath " + customFieldGroup.getAssetPath()));
        }
        if (this.fieldsWithOptions != null && !this.fieldsWithOptions.isEmpty()) {
            this.updateContentClass(this.fieldsWithOptions, customFieldGroup, session);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateContentClass(List<CustomField> list, CustomFieldGroup customFieldGroup, org.hibernate.Session session) throws ContentClassPersistenceException {
        try {
            String string = "select id, typeId, name, description, specialUsageId, isDefault from ContentClassEntity";
            Query query = session.createQuery(string);
            List list2 = query.list();
            List<ContentClass> list3 = this.createContentClassList(list2);
            if (list3 == null) return;
            for (ContentClass contentClass : list3) {
                try {
                    ContentClass contentClass2 = this.getContentClassById(contentClass.getId(), session);
                    if (contentClass2 == null) continue;
                    ContentClassMetadata contentClassMetadata = contentClass2.getMetadata();
                    if (contentClassMetadata == null) {
                        contentClassMetadata = new ContentClassMetadata();
                        contentClass2.setMetadata(contentClassMetadata);
                    }
                    logger.info((Object)("Update content class " + contentClass.getId()));
                    for (CustomField customField : list) {
                        Object object;
                        List<VariableOption> list4 = customField.getOptionList();
                        String string2 = customField.getGroup().getAssetPath();
                        if (contentClass.getType() == ContentClass.Type.Series) {
                            if (string2.equalsIgnoreCase("PACKAGE/POSTER")) {
                                object = contentClassMetadata.getAsset("SERIES/SEASON/POSTER");
                                if (object == null) {
                                    object = new ContentClassAsset("SERIES/SEASON/POSTER");
                                    object.setDisabled(Boolean.valueOf(true));
                                    contentClassMetadata.addAsset((ContentClassAsset)object);
                                }
                                this.updateAsset((ContentClassAsset)object, customField, list4);
                            }
                            if (string2.equalsIgnoreCase("PACKAGE/BOXCOVER")) {
                                object = contentClassMetadata.getAsset("SERIES/SEASON/BOXCOVER");
                                if (object == null) {
                                    object = new ContentClassAsset("SERIES/SEASON/BOXCOVER");
                                    object.setDisabled(Boolean.valueOf(true));
                                    contentClassMetadata.addAsset((ContentClassAsset)object);
                                }
                                this.updateAsset((ContentClassAsset)object, customField, list4);
                            }
                            if (((String)(object = this.getSeriesPath(string2))).equalsIgnoreCase("PACKAGE")) continue;
                            ContentClassAsset contentClassAsset = contentClassMetadata.getAsset((String)object);
                            if (contentClassAsset == null) {
                                contentClassAsset = new ContentClassAsset((String)object);
                                contentClassAsset.setDisabled(Boolean.valueOf(true));
                                contentClassMetadata.addAsset(contentClassAsset);
                            }
                            this.updateAsset(contentClassAsset, customField, list4);
                            continue;
                        }
                        object = contentClassMetadata.getAsset(string2);
                        if (object == null) {
                            object = new ContentClassAsset(string2);
                            object.setDisabled(Boolean.valueOf(true));
                            contentClassMetadata.addAsset((ContentClassAsset)object);
                        }
                        this.updateAsset((ContentClassAsset)object, customField, list4);
                    }
                    this.saveContentClass(contentClass2, session);
                }
                catch (ContentClassPersistenceException contentClassPersistenceException) {
                    logger.error((Object)contentClassPersistenceException);
                    throw new ContentClassPersistenceException((Throwable)contentClassPersistenceException);
                    return;
                }
            }
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    private void updateAsset(ContentClassAsset contentClassAsset, CustomField customField, List<VariableOption> list) {
        ContentClassField contentClassField = contentClassAsset.getField(this.getFieldPath(customField));
        if (contentClassField != null) {
            if (contentClassField.getOptions() == null || contentClassField.getOptions().isEmpty()) {
                this.addOptions(list, contentClassField);
                logger.info((Object)("Update content class: add options to field" + contentClassField.getPath()));
            }
        } else {
            ContentClassField contentClassField2 = new ContentClassField(this.getFieldPath(customField));
            contentClassField2.setDisabled(Boolean.valueOf(true));
            this.addOptions(list, contentClassField2);
            contentClassAsset.addField(contentClassField2);
        }
    }

    private String getSeriesPath(String string) {
        String string2 = new String(string);
        String string3 = "SERIES";
        String string4 = "PACKAGE";
        if (string2 != null) {
            if (string2.equalsIgnoreCase(string4)) {
                return string2;
            }
            if (string2.startsWith(string4)) {
                string2 = string2.replaceAll(string4, string3);
            }
        }
        return string2;
    }

    private void addCCGroup(CustomFieldGroup customFieldGroup, ContentClassAsset contentClassAsset, boolean bl) {
        ContentClassField contentClassField = new ContentClassField(this.getGroupPath(customFieldGroup));
        if (!bl) {
            contentClassField.setDisabled(Boolean.valueOf(true));
        } else {
            contentClassField.setDisabled(Boolean.valueOf(false));
        }
        contentClassAsset.addField(contentClassField);
    }

    private String getGroupPath(CustomFieldGroup customFieldGroup) {
        String string = "/Fields/CustomFields;" + customFieldGroup.getUuid();
        return string;
    }

    public void saveContentClass(ContentClass contentClass, org.hibernate.Session session) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return;
        }
        try {
            ContentClassEntity contentClassEntity = ContentClassHibernateFactory.createContentClassHibernate((ContentClass)contentClass);
            session.saveOrUpdate((Object)contentClassEntity);
            contentClass.setId(contentClassEntity.id);
        }
        catch (Exception exception) {
            String string = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    private void addOptions(List<VariableOption> list, ContentClassField contentClassField) {
        if (list != null) {
            for (VariableOption variableOption : list) {
                ContentClassOption contentClassOption = new ContentClassOption();
                contentClassOption.setDisplayName(variableOption.getName());
                contentClassOption.setValue(variableOption.getValue());
                contentClassField.addOption(contentClassOption);
            }
        }
    }

    private String getFieldPath(CustomField customField) {
        String string = "/Fields/CustomFields/CustomField[@name=" + customField.getName() + "]/@value";
        return string;
    }

    private List<ContentClass> createContentClassList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<ContentClass> arrayList = new ArrayList<ContentClass>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = (Object[])list.get(i);
            ContentClass contentClass = new ContentClass();
            contentClass.setId(((Long)objectArray[0]).longValue());
            int n = (Integer)objectArray[1];
            switch (n) {
                case 0: {
                    contentClass.setType(ContentClass.Type.Package);
                    break;
                }
                case 1: {
                    contentClass.setType(ContentClass.Type.Series);
                    break;
                }
                case 2: {
                    contentClass.setType(ContentClass.Type.Category);
                    break;
                }
                default: {
                    contentClass.setType(ContentClass.Type.Package);
                }
            }
            contentClass.setName((String)objectArray[2]);
            contentClass.setDescription((String)objectArray[3]);
            int n2 = (Integer)objectArray[4];
            switch (n2) {
                case 1: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            contentClass.setDefault(((Boolean)objectArray[5]).booleanValue());
            arrayList.add(contentClass);
        }
        return arrayList;
    }

    private boolean groupExists(CustomFieldGroup customFieldGroup, org.hibernate.Session session) {
        SQLQuery sQLQuery = session.createSQLQuery("select * from mdm_custom_field_group where display_name = ? and asset_path = ?").addEntity(CustomFieldGroup.class);
        sQLQuery.setString(0, customFieldGroup.getDisplayName());
        sQLQuery.setString(1, customFieldGroup.getAssetPath());
        List list = sQLQuery.list();
        return list != null && !list.isEmpty();
    }

    public List<CustomFieldGroup> getAllGroups(org.hibernate.Session session) {
        List list = null;
        SQLQuery sQLQuery = session.createSQLQuery("select * from mdm_custom_field_group order by createdate desc").addEntity(CustomFieldGroup.class);
        list = sQLQuery.list();
        return list;
    }

    private boolean fieldExists(CustomField customField, org.hibernate.Session session, String string) {
        Query query = session.createSQLQuery("select * from mdm_custom_field where name = ?").addEntity(CustomField.class).setString(0, customField.getName());
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            for (CustomField customField2 : list) {
                if (customField2.getGroup().getAssetPath().equalsIgnoreCase(string)) {
                    return true;
                }
                if (customField2.getDataType().equalsIgnoreCase(customField.getDataType())) continue;
                return true;
            }
        }
        return false;
    }

    public ContentClass getContentClassById(long l, org.hibernate.Session session) throws ContentClassPersistenceException {
        try {
            ContentClassEntity contentClassEntity = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(l));
            if (contentClassEntity == null) {
                String string = "Content class with id = " + l + " doesn't exist";
                throw new ContentClassPersistenceException(string);
            }
            session.evict((Object)contentClassEntity);
            return ContentClassHibernateFactory.createContentClass((ContentClassEntity)contentClassEntity);
        }
        catch (Exception exception) {
            String string = "Unable to get a content classes with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, (Throwable)exception);
        }
    }

    static {
        logger = Logger.getLogger(UpgradeDBManager.class);
    }
}

