/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.util.XPathTranslator;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;

public class ContentClassBuilder {
    private Specification spec;
    private ContentClassMetadata ccMeta;
    private ContentClassAsset currentCCAsset;
    private ContentClassMetadata newCCMeta;
    private ContentClassAsset currentNewCCAsset;

    public ContentClassBuilder(Specification specification) throws Exception {
        this.spec = specification;
        XPathTranslator.instance().init();
    }

    public ContentClassMetadata convertMetadata(ContentClassMetadata contentClassMetadata) throws Exception {
        this.ccMeta = contentClassMetadata;
        this.newCCMeta = new ContentClassMetadata();
        TitleType titleType = this.spec.getTitle();
        this.walkTitleTree(titleType, null);
        this.convertTrickModeRestrictions(this.newCCMeta, "PACKAGE/MOVIE");
        this.convertTrickModeRestrictions(this.newCCMeta, "PACKAGE/PREVIEW");
        return this.newCCMeta;
    }

    private void convertTrickModeRestrictions(ContentClassMetadata contentClassMetadata, String string) {
        String string2;
        ContentClassField contentClassField;
        ContentClassAsset contentClassAsset = contentClassMetadata.getAsset(string);
        if (contentClassAsset == null) {
            contentClassAsset = new ContentClassAsset(string);
            contentClassAsset.setDisabled(true);
        }
        if ((contentClassField = contentClassAsset.getField(string2 = "/Fields/TrickModeRestrictions/TrickModeRestriction")) == null) {
            contentClassField = new ContentClassField(string2);
            contentClassField.setDisabled(true);
        }
        if (contentClassField.getMax() == null) {
            contentClassField.setMax(1);
        }
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.currentCCAsset = this.ccMeta.getAsset(string);
        this.currentNewCCAsset = new ContentClassAsset(string);
        this.newCCMeta.addAsset(this.currentNewCCAsset);
        if (this.currentCCAsset != null) {
            this.currentNewCCAsset.setDisabled(this.currentCCAsset.isDisabled());
            this.currentNewCCAsset.setMin(this.currentCCAsset.getMin());
            this.currentNewCCAsset.setMax(this.currentCCAsset.getMax());
            this.currentNewCCAsset.setBatchMin(this.currentCCAsset.getBatchMin());
            this.currentNewCCAsset.setBatchMax(this.currentCCAsset.getBatchMax());
            this.currentNewCCAsset.setHideFileView(this.currentCCAsset.isHideFileView());
            this.currentNewCCAsset.setRequiresFile(this.currentCCAsset.isRequiresFile());
            if (this.currentCCAsset.isDisabled()) {
                return;
            }
        }
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            List<VariableType> list2;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                list2 = (SimpleVariableType)variableType;
                if (((SimpleVariableType)((Object)list2)).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                this.processField(string3);
                continue;
            }
            this.processField(string3);
            list2 = variableType.getVariable();
            if (list2 == null || list2.isEmpty()) continue;
            this.walkVariableTree(list2, string3);
        }
    }

    private void processField(String string) {
        ContentClassField contentClassField;
        ContentClassField contentClassField2 = contentClassField = this.currentCCAsset == null ? null : this.currentCCAsset.getField(string);
        if (contentClassField != null) {
            String string2 = XPathTranslator.instance().old2new(string);
            contentClassField.setPath(string2);
            this.currentNewCCAsset.addField(contentClassField);
        } else {
            String string3 = XPathTranslator.instance().old2new(string);
            this.currentNewCCAsset.addField(new ContentClassField(string3));
        }
    }
}

