/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.DateVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TimeVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CustomFieldDataTypeMappingHandler {
    private Specification spec;
    private Map<String, String> dtMap = new TreeMap<String, String>();

    public CustomFieldDataTypeMappingHandler(Specification specification) throws Exception {
        this.spec = specification;
        SpecUtil.loadDataTypeMappingTemplate(this.dtMap);
    }

    public void process() {
        TitleType titleType = this.spec.getTitle();
        this.walkTitleTree(titleType);
    }

    private void walkTitleTree(TitleType titleType) {
        this.processTitle(titleType);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2);
        }
    }

    private void processTitle(TitleType titleType) {
        VariableType variableType = SpecUtil.findCustomFieldsVariable(titleType);
        if (variableType != null) {
            for (VariableType variableType2 : variableType.getVariable()) {
                this.processCustomVariable(variableType2);
            }
        }
    }

    private void processCustomVariable(VariableType variableType) {
        if (variableType.getVariable() == null) {
            return;
        }
        String string = variableType.getName();
        for (VariableType variableType2 : variableType.getVariable()) {
            if (!variableType2.getName().equals("value")) continue;
            String string2 = "/Fields/CustomFields/" + string + "/@value";
            String string3 = "string";
            if (variableType2 instanceof BooleanVariableType) {
                string3 = "boolean";
            } else if (variableType2 instanceof IntegerVariableType) {
                string3 = "integer";
            } else if (variableType2 instanceof FloatVariableType) {
                string3 = "float";
            } else if (variableType2 instanceof DateVariableType) {
                string3 = "date";
            } else if (variableType2 instanceof TimeVariableType) {
                string3 = "time";
            }
            this.dtMap.put(string2, string3);
            return;
        }
    }

    public Map<String, String> getDataTypeMap() {
        return this.dtMap;
    }
}

