/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.entities;

import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ContentClassField
implements Serializable {
    private static final long serialVersionUID = 1946025321716873919L;
    private String path;
    private boolean disabled;
    private boolean isLocked;
    private boolean isAttribute;
    private boolean isRequired;
    private Integer min;
    private Integer max;
    private boolean includeInBatch;
    private boolean isAutofillable;
    private String autofillProvider;
    private String displayPattern;
    private String defaultValue;
    private List<ContentClassOption> options;
    private Set<String> disabledOptionKeys;

    public ContentClassField(String string) {
        this.path = string;
    }

    public ContentClassField(ContentClassField contentClassField) {
        this.autofillProvider = contentClassField.autofillProvider;
        this.defaultValue = contentClassField.defaultValue;
        this.addDisabledOptionKeys(contentClassField.getDisabledOptionKeys());
        this.displayPattern = contentClassField.displayPattern;
        this.includeInBatch = contentClassField.includeInBatch;
        this.isAttribute = contentClassField.isAttribute;
        this.isAutofillable = contentClassField.isAutofillable;
        this.isLocked = contentClassField.isLocked;
        this.disabled = contentClassField.disabled;
        this.isRequired = contentClassField.isRequired;
        this.max = contentClassField.max;
        this.min = contentClassField.min;
        this.addOptions(contentClassField.getOptions());
        this.path = contentClassField.path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.isLocked = bl;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public List<ContentClassOption> getOptions() {
        return this.options;
    }

    public void addOption(ContentClassOption contentClassOption) {
        if (contentClassOption == null) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<ContentClassOption>();
        }
        this.options.add(contentClassOption);
    }

    public void addOptions(Collection<ContentClassOption> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<ContentClassOption>();
        }
        this.options.addAll(collection);
    }

    public Set<String> getDisabledOptionKeys() {
        return this.disabledOptionKeys;
    }

    public void addDisabledOptionKey(String string) {
        if (string == null) {
            return;
        }
        if (this.disabledOptionKeys == null) {
            this.disabledOptionKeys = new TreeSet<String>();
        }
        this.disabledOptionKeys.add(string);
    }

    public void addDisabledOptionKeys(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.disabledOptionKeys == null) {
            this.disabledOptionKeys = new TreeSet<String>();
        }
        this.disabledOptionKeys.addAll(collection);
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.isAttribute = bl;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer n) {
        this.min = n;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer n) {
        this.max = n;
    }

    public boolean getIncludeInBatch() {
        return this.includeInBatch;
    }

    public void setIncludeInBatch(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.includeInBatch = bl;
    }

    public boolean isAutofillable() {
        return this.isAutofillable;
    }

    public void setAutofillable(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.isAutofillable = bl;
    }

    public String getAutofillProvider() {
        return this.autofillProvider;
    }

    public void setAutofillProvider(String string) {
        this.autofillProvider = "null".equalsIgnoreCase(string) ? null : string;
    }

    public String getDisplayPattern() {
        return this.displayPattern;
    }

    public void setDisplayPattern(String string) {
        this.displayPattern = string;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.isRequired = bl;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.disabled = bl;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }
}

