/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.option;

import com.tandbergtv.content.contentclass.option.AssetInfo;
import com.tandbergtv.content.contentclass.option.OldSpecOptionsParser;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.OptionsType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OptionsMerger {
    private static Logger logger = Logger.getLogger(OptionsMerger.class);
    private Map<String, AssetInfo> assetsWithOptions;
    private AssetInfo currentTitleInfo;

    public void merge(UISpecification uISpecification, Specification specification) {
        OldSpecOptionsParser oldSpecOptionsParser = new OldSpecOptionsParser();
        oldSpecOptionsParser.parseSpec(uISpecification);
        this.assetsWithOptions = oldSpecOptionsParser.getAssetsWithOptions();
        TitleType titleType = specification.getTitle();
        this.walkTitleTree(titleType, null);
        logger.debug((Object)"======================================================");
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.currentTitleInfo = this.assetsWithOptions.get(string);
        if (this.currentTitleInfo == null) {
            return;
        }
        logger.debug((Object)"======================================================");
        logger.debug((Object)string);
        logger.debug((Object)"======================================================");
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                SimpleVariable simpleVariable;
                object = (SimpleVariableType)variableType;
                if (((SimpleVariableType)object).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                if ((simpleVariable = this.currentTitleInfo.findVariableByPath(string3)) != null) {
                    this.replaceOptions(string3, (SimpleVariableType)object, simpleVariable);
                }
            }
            if ((object = variableType.getVariable()) == null || object.isEmpty()) continue;
            this.walkVariableTree((List<VariableType>)object, string3);
        }
    }

    private void replaceOptions(String string, SimpleVariableType simpleVariableType, SimpleVariable simpleVariable) {
        Object object;
        if (simpleVariableType.getOptions() != null && (object = simpleVariableType.getOptions().getOptionProvider()) != null) {
            logger.debug((Object)("Skipping old options for " + string + ". New spec has option provider " + (String)object));
            return;
        }
        logger.debug((Object)("Replacing options for " + string));
        object = new OptionsType();
        ((OptionsType)object).setAnyValueAllowed(simpleVariable.isAnyValueAllowed());
        List<OptionsType.Option> list = ((OptionsType)object).getOption();
        List<VariableOption> list2 = simpleVariable.getOptions();
        if (list2 == null) {
            return;
        }
        for (VariableOption variableOption : list2) {
            String string2 = variableOption.getName();
            String string3 = variableOption.getValue();
            logger.debug((Object)("    " + string2 + " = " + string3));
            OptionsType.Option option = new OptionsType.Option();
            option.setName(string2);
            option.setValue(string3);
            list.add(option);
        }
        simpleVariableType.setOptions((OptionsType)object);
    }
}

