/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OptionsBuilder {
    private static Logger logger = Logger.getLogger(OptionsBuilder.class);
    private Map<String, Map<String, String>> fieldsMap = new HashMap<String, Map<String, String>>();

    public void addOptions(UISpecification uISpecification) {
        if (uISpecification == null) {
            return;
        }
        List<TitleConf> list = uISpecification.getAllTitleConf();
        if (list != null) {
            for (TitleConf titleConf : list) {
                List<Variable> list2 = titleConf.getMetadata();
                if (list2 == null) continue;
                for (Variable variable : list2) {
                    this.addVariable(variable);
                }
            }
        }
    }

    public void addOptions(Map<String, Map<String, String>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            Map<String, String> map2 = this.fieldsMap.get(string);
            Map<String, String> map3 = map.get(string);
            if (map2 == null || map3 == null) continue;
            for (Map.Entry<String, String> entry : map3.entrySet()) {
                if (map2.containsKey(entry.getKey())) continue;
                map2.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addOptions(SimpleVariable simpleVariable) {
        String string = simpleVariable.getXPath();
        Map<String, String> map = this.fieldsMap.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.fieldsMap.put(string, map);
        }
        String string2 = simpleVariable.getOptionProvider();
        List<VariableOption> list = simpleVariable.getOptions();
        if (list != null) {
            for (VariableOption variableOption : list) {
                if (map.containsKey(variableOption.getValue())) continue;
                map.put(variableOption.getValue(), variableOption.getName());
            }
        }
    }

    private void addVariable(Variable variable) {
        ComplexVariable complexVariable;
        List<Variable> list;
        if (variable == null) {
            return;
        }
        if (variable instanceof SimpleVariable) {
            SimpleVariable simpleVariable = (SimpleVariable)variable;
            if (simpleVariable.hasOptions()) {
                this.addOptions(simpleVariable);
            }
        } else if (variable instanceof ComplexVariable && (list = (complexVariable = (ComplexVariable)variable).getChildren()) != null) {
            for (Variable variable2 : list) {
                this.addVariable(variable2);
            }
        }
    }

    public Map<String, Map<String, String>> getFields() {
        return this.fieldsMap;
    }
}

