#!/bin/sh
ORACLE_SID=$1
if [ "${ORACLE_SID}" = ""  ];
then
  echo ""
  echo "Run the script with SID as first parameter, example:  sh chgdbarchivemode.sh ttv"
  echo ""
  exit 1
fi
ARCH_MODE=$(sqlplus -S /nolog<<SQL1
  connect / as sysdba
  set pages 0
  set feedback off
  SELECT LOG_MODE FROM SYS.V\$DATABASE;
  exit
SQL1
)
if [ "${ARCH_MODE}" = "NOARCHIVELOG" ]; then

sqlplus -S /nolog<<EOFSQL
  connect / as sysdba
  shut immediate
  startup mount
  alter database archivelog;
  alter database open;
  exit
EOFSQL

  echo ""
  echo "Database has changed to archive mode successfully..."
  echo ""
elif [ "${ARCH_MODE}" = "ARCHIVELOG" ]; then
  echo ""
  echo "Database is already running in archive mode."
  echo ""
fi

