#!/bin/sh
START=$(date +%s)
TIMESTAMP=`date --utc -d "@$(( $START ))" +%Y%m%d_%H%M%S`
(
mkdir /home/upgrade/upgrade_conf_files
if [ $? -eq 0 ]; then
  if [ -d  "/home/upgrade/prev_conf_files"  ] 
  then
    ## system info ##
    echo "Starting Appliance Update @ "$(date '+%Y-%m-%d %H:%M:%S')
    echo "System Name.................." $HOSTNAME
    echo "System IP...................." `cat /etc/hosts | grep $HOSTNAME | awk '{print $1}'`
    echo "Appliance Verions............" `conary q | grep appliance | awk -F= '{print $2}'`
    echo "Conary Version..............." `conary q --version`
 
    ## Stop Services 
    service oracle stop

    cp /etc/sysctl.conf          /home/upgrade/upgrade_conf_files/sysctl.conf.bak 
    cp /etc/security/limits.conf /home/upgrade/upgrade_conf_files/limits.conf.bak
    cp /etc/oratab               /home/upgrade/upgrade_conf_files/oratab.bak
    cp /etc/init.d/oracle        /home/upgrade/upgrade_conf_files/oracle_service 
    cp /etc/oraInst.loc          /home/upgrade/upgrade_conf_files/oraInst.loc.bak

    cp /home/oracle/.bash_profile                               /home/upgrade/upgrade_conf_files/oracle_profile.bak
    cp /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql /home/upgrade/upgrade_conf_files/glogin.sql.bak
    cp /opt/oracle/backup/scripts/rman_backup.ksh               /home/upgrade/upgrade_conf_files/rman_backup.ksh
    cp /opt/oracle/backup/scripts/rman_backup_arch.ksh          /home/upgrade/upgrade_conf_files/rman_backup_arch.ksh

    su - oracle -c "crontab -l > /home/oracle/oracle_cron.bak"
    cp /home/oracle/oracle_cron.bak /home/upgrade/upgrade_conf_files/oracle_cron.bak

    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.ctl /home/upgrade/upgrade_conf_files/ttv.ctl
    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dfb /home/upgrade/upgrade_conf_files/ttv.dfb
    cp /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dbc /home/upgrade/upgrade_conf_files/ttv.dbc
    crontab -l > /home/upgrade/upgrade_conf_files/root_cron.bak

    ## rollback appliance ##
    conary rb r.1

    ## restore oracle databases
    #mv /opt/oracle /opt/oracle_bkup
    rm -rf /opt/oracle
    tar -xzvpf /home/upgrade/oracle.tar.gz -C /opt

    #echo "127.0.0.1         `hostname`" >> /etc/hosts

    mkdir -p /opt/oracle/product/11.2.0/db_1/dbs/dbs/arch
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/dbs/arch
    mkdir -p /opt/oracle/backup/scripts
    chown -R oracle:oinstall /opt/oracle/
    mkdir -p /opt/oracle/oradata
    chown -R oracle:oinstall /opt/oracle/oradata
    mkdir -p /opt/oracle/admin
    chown -R oracle:oinstall /opt/oracle/admin

    cp -f /home/upgrade/prev_conf_files/sysctl.conf.bak /etc/sysctl.conf
    cp -f /home/upgrade/prev_conf_files/limits.conf.bak /etc/security/limits.conf
    cp -f /home/upgrade/prev_conf_files/oratab.bak /etc/oratab
    cp -f /home/upgrade/prev_conf_files/oraInst.loc.bak /etc/oraInst.loc
    sysctl -p
    cp -f /home/upgrade/prev_conf_files/oracle_profile.bak /home/oracle/.bash_profile
    cp -f /home/upgrade/prev_conf_files/glogin.sql.bak /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql
    cp -f /home/upgrade/prev_conf_files/rman_backup.ksh /opt/oracle/backup/scripts/rman_backup.ksh 
    cp -f /home/upgrade/prev_conf_files/rman_backup_arch.ksh /opt/oracle/backup/scripts/rman_backup_arch.ksh
    chown root:root /etc/oraInst.loc
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/sqlplus/admin/glogin.sql
    chown oracle:oinstall /opt/oracle/backup/scripts/rman_backup*.ksh
    chown oracle:oinstall /home/oracle/.bash_profile
    chmod 755 /opt/oracle/backup/scripts/rman_backup*.ksh
  
    cp -f /home/upgrade/prev_conf_files/ttv.ctl /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.ctl
    cp -f /home/upgrade/prev_conf_files/ttv.dfb /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dfb
    cp -f /home/upgrade/prev_conf_files/ttv.dbc /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.dbc
    cp -f /home/upgrade/prev_conf_files/oracle_service /etc/init.d/oracle
    chown oracle:oinstall /opt/oracle/product/11.2.0/db_1/assistants/dbca/templates/ttv.*
    chown root:root /etc/init.d/oracle
    chmod 755 /etc/init.d/oracle
    ln -s /usr/bin /usr/local/bin
    
    service oracle start

    # clean up the conf file folders
    zip /home/upgrade/prev_conf_files_$TIMESTAMP.zip /home/upgrade/prev_conf_files/*
    zip /home/upgrade/upgrade_conf_files_$TIMESTAMP.zip /home/upgrade/upgrade_conf_files/*
    rm -rf /home/upgrade/prev_conf_files
    rm -rf /home/upgrade/upgrade_conf_files

  else
    echo "Previous configuration files are missing."
  fi
else
  echo "This machine is already rolledback."
  exit 1
fi       
) 2>&1 | tee /home/upgrade/$TIMESTAMP.rollback.log
