<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml">

	<xsl:output method="text" omit-xml-declaration="yes" />

	<xsl:template match="/">
		<xsl:call-template name="nodeSet" />
	</xsl:template>

	<xsl:template name="nodeSet">
		<xsl:param name="path"/>
		<xsl:for-each select="*">
			<xsl:variable name="position"><xsl:number /></xsl:variable>
			<xsl:variable name="name"
				select="concat($path, '/', name(), '{', $position, '}')" />
			<xsl:for-each select="@*">
				<xsl:value-of 
					select="concat($name, '/@', name(), '==', current())" />
				<xsl:text>#ttv#ttv#ttv#ttv#&#xA;</xsl:text>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="not(*)">
					<xsl:value-of
						select="concat($name, '==', current())" />
					<xsl:text>#ttv#ttv#ttv#ttv#&#xA;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="nodeSet">
						<xsl:with-param name="path" select="$name" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>
