/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationParserUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.Iterator;
import java.util.List;

public class CustomFieldHandler {
    private boolean DEBUG = false;
    private SpecInfo info;

    public CustomFieldHandler(SpecInfo specInfo) {
        this.info = specInfo;
    }

    public void mergeCustomFields() {
        TitleType titleType = this.info.newSpec.getTitle();
        this.walkTitleTree(titleType, null);
        this.debug("======================================================");
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        TitleInfo titleInfo = this.info.findTitleByPath(string);
        if (titleInfo == null || titleInfo.getCustomFieldsRef() == null) {
            return;
        }
        this.debug("======================================================");
        this.debug(string);
        this.debug("======================================================");
        VariableType variableType = SpecificationParserUtil.findCustomFieldsVariable(titleType);
        if (variableType == null) {
            SpecificationParserUtil.addCustomFieldsVariable(titleType, titleInfo.getCustomFieldsRef());
            for (VariableType variableType2 : titleInfo.getCustomFieldsRef().getVariable()) {
                this.debug("Adding " + variableType2.getName());
            }
        } else {
            List<VariableType> list = variableType.getVariable();
            Iterator<VariableType> iterator = list.iterator();
            while (iterator.hasNext()) {
                VariableType variableType3 = iterator.next();
                if (!titleInfo.containsCustomField(variableType3.getName())) continue;
                this.debug("Deleting " + variableType3.getName());
                iterator.remove();
            }
            list = titleInfo.getCustomFieldsRef().getVariable();
            for (VariableType variableType4 : list) {
                this.debug("Adding " + variableType4.getName());
                variableType.getVariable().add(variableType4);
            }
        }
    }

    private void debug(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }
}

