/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.util.StringUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.FieldInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.FieldOption;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleInfo;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.BooleanVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.FloatVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.IntegerVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.SimpleVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.StringVariableType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.util.List;

public class OptionHandler {
    private boolean DEBUG = false;
    private SpecInfo info;
    private TitleInfo currentTitleInfo;

    public OptionHandler(SpecInfo specInfo) {
        this.info = specInfo;
    }

    public void process() {
        TitleType titleType = this.info.newSpec.getTitle();
        this.walkTitleTree(titleType, null);
        this.debug("======================================================");
    }

    private void walkTitleTree(TitleType titleType, String string) {
        String string2 = titleType.getName();
        String string3 = string == null ? string2 : string + "/" + string2;
        this.processTitle(titleType, string3);
        if (titleType.getChildTitles() == null) {
            return;
        }
        List<TitleType> list = titleType.getChildTitles().getTitle();
        for (TitleType titleType2 : list) {
            this.walkTitleTree(titleType2, string3);
        }
    }

    private void processTitle(TitleType titleType, String string) {
        this.currentTitleInfo = this.info.findTitleByPath(string);
        if (this.currentTitleInfo == null) {
            return;
        }
        this.debug("======================================================");
        this.debug(string);
        this.debug("======================================================");
        List<VariableType> list = titleType.getMetadata().getVariable();
        this.walkVariableTree(list, "/Fields");
    }

    private void walkVariableTree(List<VariableType> list, String string) {
        for (VariableType variableType : list) {
            Object object;
            String string2 = variableType.getName();
            String string3 = string + "/" + string2;
            if (variableType instanceof SimpleVariableType) {
                FieldInfo fieldInfo;
                object = (SimpleVariableType)variableType;
                if (((SimpleVariableType)object).isAttribute()) {
                    string3 = string + "/@" + string2;
                }
                if ((fieldInfo = this.currentTitleInfo.getFieldInfo(string3)) != null) {
                    this.replaceOptions(string3, (SimpleVariableType)object, fieldInfo);
                }
            }
            if ((object = variableType.getVariable()) == null || object.isEmpty()) continue;
            this.walkVariableTree((List<VariableType>)object, string3);
        }
    }

    private void replaceOptions(String string, SimpleVariableType simpleVariableType, FieldInfo fieldInfo) {
        this.debug("Replacing options for " + string);
        FieldInfo.DataType dataType = fieldInfo.getDataType();
        if (dataType == FieldInfo.DataType.STRING) {
            if (simpleVariableType instanceof StringVariableType) {
                StringVariableType.Options options = new StringVariableType.Options();
                options.setAnyValueAllowed(fieldInfo.isAnyOptionValueAllowed());
                List<StringVariableType.Options.Option> list = options.getOption();
                if (fieldInfo.getOptions() != null) {
                    for (FieldOption fieldOption : fieldInfo.getOptions()) {
                        String string2 = fieldOption.getName();
                        String string3 = fieldOption.getValue();
                        this.debug(string2 + " = " + string3);
                        StringVariableType.Options.Option option = new StringVariableType.Options.Option();
                        option.setName(string2);
                        option.setValue(string3);
                        list.add(option);
                    }
                }
                StringVariableType stringVariableType = (StringVariableType)simpleVariableType;
                stringVariableType.setOptions(options);
            } else {
                System.out.println("Type mismatch for " + string);
            }
        } else if (dataType == FieldInfo.DataType.BOOLEAN) {
            if (simpleVariableType instanceof BooleanVariableType) {
                BooleanVariableType.Options options = new BooleanVariableType.Options();
                options.setAnyValueAllowed(fieldInfo.isAnyOptionValueAllowed());
                List<BooleanVariableType.Options.Option> list = options.getOption();
                for (FieldOption fieldOption : fieldInfo.getOptions()) {
                    String string4 = fieldOption.getName();
                    String string5 = fieldOption.getValue();
                    this.debug(string4 + " = " + string5);
                    BooleanVariableType.Options.Option option = new BooleanVariableType.Options.Option();
                    option.setName(string4);
                    option.setValue(string5.equalsIgnoreCase("true"));
                    list.add(option);
                }
                BooleanVariableType booleanVariableType = (BooleanVariableType)simpleVariableType;
                booleanVariableType.setOptions(options);
            } else {
                System.out.println("Type mismatch for " + string);
            }
        } else if (dataType == FieldInfo.DataType.INTEGER) {
            if (simpleVariableType instanceof IntegerVariableType) {
                IntegerVariableType.Options options = new IntegerVariableType.Options();
                options.setAnyValueAllowed(fieldInfo.isAnyOptionValueAllowed());
                List<IntegerVariableType.Options.Option> list = options.getOption();
                for (FieldOption fieldOption : fieldInfo.getOptions()) {
                    String string6 = fieldOption.getName();
                    String string7 = fieldOption.getValue();
                    this.debug(string6 + " = " + string7);
                    IntegerVariableType.Options.Option option = new IntegerVariableType.Options.Option();
                    option.setName(string6);
                    option.setValue(StringUtil.parseInt(string7));
                    list.add(option);
                }
                IntegerVariableType integerVariableType = (IntegerVariableType)simpleVariableType;
                integerVariableType.setOptions(options);
            } else {
                System.out.println("Type mismatch for " + string);
            }
        } else if (dataType == FieldInfo.DataType.FLOAT) {
            if (simpleVariableType instanceof FloatVariableType) {
                FloatVariableType.Options options = new FloatVariableType.Options();
                options.setAnyValueAllowed(fieldInfo.isAnyOptionValueAllowed());
                List<FloatVariableType.Options.Option> list = options.getOption();
                for (FieldOption fieldOption : fieldInfo.getOptions()) {
                    String string8 = fieldOption.getName();
                    String string9 = fieldOption.getValue();
                    this.debug(string8 + " = " + string9);
                    FloatVariableType.Options.Option option = new FloatVariableType.Options.Option();
                    option.setName(string8);
                    option.setValue(StringUtil.parseFloat(string9));
                    list.add(option);
                }
                FloatVariableType floatVariableType = (FloatVariableType)simpleVariableType;
                floatVariableType.setOptions(options);
            } else {
                System.out.println("Type mismatch for " + string);
            }
        }
    }

    private void debug(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }
}

