/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.SpecInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PropertyConverter {
    public void process(SpecInfo specInfo, String string, String string2) throws Exception {
        Serializable serializable;
        File file;
        System.out.println("Merging old properties...");
        File file2 = new File(string);
        String string3 = file2.getName();
        if (string2 == null) {
            file = new File(string3);
        } else {
            serializable = new File(string2);
            if (!serializable.exists()) {
                serializable.mkdirs();
            }
            file = new File((File)serializable, string3);
        }
        System.out.print("Loading old properties from " + string + " ...");
        serializable = this.loadOldProperties(string);
        System.out.println(" done");
        Properties properties = this.loadDefaultProperties();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        treeMap.putAll(properties);
        treeMap.putAll((Map<Object, Object>)((Object)serializable));
        Set<String> set = specInfo.getAutoFillProviders();
        if (set != null) {
            for (String string4 : set) {
                treeMap.put(string4, string4);
            }
        }
        System.out.print("Writing merged properties to " + file.getAbsolutePath() + " ...");
        this.writeProperties(treeMap, file);
        System.out.println(" done");
    }

    private void writeProperties(Map<Object, Object> map, File file) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("# Autogenerated");
        bufferedWriter.newLine();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            bufferedWriter.write(entry.getKey() + "=" + entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    private Properties loadOldProperties(String string) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileReader(string));
        return properties;
    }

    private Properties loadDefaultProperties() throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(PropertyConverter.class.getClassLoader().getResourceAsStream("ecmf.properties")));
        Properties properties = new Properties();
        properties.load(bufferedReader);
        return properties;
    }
}

