/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.ericsson.converter.spec.ConvertCC12;
import com.ericsson.converter.spec.OldSpec;
import com.ericsson.converter.spec.OldSpecParser12;
import com.tandbergtv.content.contentclass.SpecConverter12;
import com.tandbergtv.content.contentclass.util.XPathTranslator;
import java.io.File;
import org.apache.log4j.Logger;

public class ConvertSpec12 {
    private static Logger logger = Logger.getLogger(ConvertSpec12.class);

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            ConvertSpec12.printHelp();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        File file = new File(string);
        if (!file.exists()) {
            logger.error((Object)("Input folder doesn't exist: " + string));
            return;
        }
        file = new File(string4);
        if (!file.exists()) {
            logger.error((Object)("Output folder doesn't exist: " + string4));
            return;
        }
        logger.info((Object)"Starting spec converter with the following parameters:");
        logger.info((Object)("Input directory  : " + string));
        logger.info((Object)("Spec file        : " + string2));
        logger.info((Object)("Properties file  : " + string3));
        logger.info((Object)("Output directory : " + string4));
        try {
            XPathTranslator.instance();
        }
        catch (Exception exception) {
            logger.error((Object)"Could not load XPath mappings.", (Throwable)exception);
            return;
        }
        SpecConverter12 specConverter12 = null;
        try {
            specConverter12 = new SpecConverter12(string, string4);
            specConverter12.run(string2, string3);
        }
        catch (Exception exception) {
            logger.error((Object)"Could not convert spec.", (Throwable)exception);
            return;
        }
        try {
            OldSpecParser12 oldSpecParser12 = new OldSpecParser12();
            File file2 = new File(string, string2);
            OldSpec oldSpec = oldSpecParser12.parse(file2.getAbsolutePath());
            ConvertCC12 convertCC12 = new ConvertCC12();
            convertCC12.convert(oldSpec, specConverter12.getNewSpec(), specConverter12.getNewProperties());
        }
        catch (Exception exception) {
            logger.error((Object)"Could not convert content class.", (Throwable)exception);
            return;
        }
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("    ConvertSpec12 [<inputDir> <inputSpecFile> <inputPropertiesFile> <outputDir>]");
        System.out.println("where");
        System.out.println("    <inputDir>            - Input folder with definition.xml and properties files.");
        System.out.println("                            For example: /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.cablelabsvod11.ui/resources");
        System.out.println("    <inputSpecFile>       - Name of the specification file. Usually it is definition.xml");
        System.out.println("    <inputPropertiesFile> - Name of the properties file. Usually it is cablelabsvod11.properties");
        System.out.println("    <outputDir>           - Output folder");
        System.out.println("                            For example: /opt/tandbergtv/cms/plugins/content/com.tandbergtv.metadata.ecmf.ui/resources");
    }
}

