/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.hibernate.ContentClassServiceHibernate;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import com.tandbergtv.content.contentclass.util.HibernateUtil;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.AppType;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.ContentAdvisory;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Genre;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Product;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Rating;
import com.tandbergtv.watchpoint.pmm.entities.metadataconfig.Studio;
import com.tandbergtv.watchpoint.pmm.title.conf.OptionsBuilder;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class OptionsHandler {
    private static final Logger logger = Logger.getLogger(OptionsHandler.class);
    private static final String SELECT_RATING = "SelectRating";
    protected String APP_TYPE_XPATH = "/Fields/ApplicationInfo/Name";
    protected String CONTENT_ADVISORY_XPATH = "/Fields/Rating/ContentAdvisories/ContentAdvisory";
    protected String GENRE_XPATH = "/Fields/Genres/Genre/Value";
    protected String PRODUCT_XPATH = "/Fields/ProductInfo/Name";
    protected String RATING_XPATH = "/Fields/Rating/RatingValues/RatingValue/Value";
    protected String RATING_SYSTEM_XPATH = "/Fields/Rating/RatingValues/RatingValue/System";
    protected String STUDIO_DISPLAY_NAME_XPATH = "/Fields/CreationInfo/Studio/DisplayName";
    protected String STUDIO_ORGANIZATION_CODE_XPATH = "/Fields/CreationInfo/Studio/Code";
    protected String STUDIO_ORGANIZATION_NAME_XPATH = "/Fields/CreationInfo/Studio/Name";
    private List<String> CL_MPAA_RATINGS;
    private List<String> CL_TV_RATINGS;
    private List<String> CL_OTHER_RATINGS;
    private List<String> MSTV_ADULTONLY_RATING;
    private String specPath;

    public OptionsHandler(String string) {
        this.specPath = string;
        this.CL_MPAA_RATINGS = new ArrayList<String>();
        this.CL_MPAA_RATINGS.add("G");
        this.CL_MPAA_RATINGS.add("PG");
        this.CL_MPAA_RATINGS.add("PG-13");
        this.CL_MPAA_RATINGS.add("R");
        this.CL_MPAA_RATINGS.add("NC-17");
        this.CL_TV_RATINGS = new ArrayList<String>();
        this.CL_TV_RATINGS.add("TV-Y");
        this.CL_TV_RATINGS.add("TV-Y7");
        this.CL_TV_RATINGS.add("TV-G");
        this.CL_TV_RATINGS.add("TV-PG");
        this.CL_TV_RATINGS.add("TV-14");
        this.CL_TV_RATINGS.add("TV-MA");
        this.CL_OTHER_RATINGS = new ArrayList<String>();
        this.CL_OTHER_RATINGS.add("NR-ADULT");
        this.CL_OTHER_RATINGS.add("NR");
        this.CL_OTHER_RATINGS.add("Unrated");
        this.CL_OTHER_RATINGS.add("X");
        this.CL_OTHER_RATINGS.add("XX");
        this.CL_OTHER_RATINGS.add("XXX");
        this.MSTV_ADULTONLY_RATING = new ArrayList<String>();
        this.MSTV_ADULTONLY_RATING.add("AO");
    }

    public void run() throws Exception {
        HibernateUtil.initHibernate();
        UISpecification uISpecification = SpecUtil.loadUISpecification(this.specPath);
        Map<String, Map<String, String>> map = OptionsHandler.getFieldsWithOptions(uISpecification);
        logger.info((Object)"Converting to use Option Providers for App Type, Content Advisory Genre, Product, Rating and Studio");
        Map<String, String> map2 = map.get(this.APP_TYPE_XPATH);
        Map<String, String> map3 = map.get(this.CONTENT_ADVISORY_XPATH);
        Map<String, String> map4 = map.get(this.GENRE_XPATH);
        Map<String, String> map5 = map.get(this.PRODUCT_XPATH);
        Map<String, String> map6 = map.get(this.RATING_XPATH);
        Map<String, String> map7 = map.get(this.RATING_SYSTEM_XPATH);
        List<AppType> list = this.convertToAppTypes(map2);
        List<ContentAdvisory> list2 = this.convertToContentAdvisories(map3);
        List<Genre> list3 = this.convertToGenres(map4);
        List<Product> list4 = this.convertToProducts(map5);
        List<Rating> list5 = this.convertToRatings(map6, map7);
        try {
            for (AppType serializable : list) {
                this.storeAppType(serializable);
            }
            for (ContentAdvisory contentAdvisory : list2) {
                this.storeContentAdvisory(contentAdvisory);
            }
            for (Genre genre : list3) {
                this.storeGenre(genre);
            }
            for (Product product : list4) {
                this.storeProduct(product);
            }
            for (Rating rating : list5) {
                this.storeRating(rating);
            }
        }
        catch (Throwable throwable) {
            logger.fatal((Object)"Operation failed", throwable);
        }
        HibernateUtil.closeHibernate();
    }

    private List<AppType> convertToAppTypes(Map<String, String> map) {
        ArrayList<AppType> arrayList = new ArrayList<AppType>();
        if (map == null) {
            return arrayList;
        }
        for (String string : map.keySet()) {
            AppType appType = new AppType();
            appType.setAppType(string);
            appType.setNotes(string);
            arrayList.add(appType);
        }
        return arrayList;
    }

    private List<ContentAdvisory> convertToContentAdvisories(Map<String, String> map) {
        ArrayList<ContentAdvisory> arrayList = new ArrayList<ContentAdvisory>();
        if (map == null) {
            return arrayList;
        }
        for (String string : map.keySet()) {
            ContentAdvisory contentAdvisory = new ContentAdvisory();
            contentAdvisory.setContentAdvisory(string);
            contentAdvisory.setDescription(string);
            arrayList.add(contentAdvisory);
        }
        return arrayList;
    }

    private List<Genre> convertToGenres(Map<String, String> map) {
        ArrayList<Genre> arrayList = new ArrayList<Genre>();
        if (map == null) {
            return arrayList;
        }
        for (String string : map.keySet()) {
            Genre genre = new Genre();
            genre.setGenre(string);
            genre.setDescription(string);
            arrayList.add(genre);
        }
        return arrayList;
    }

    private List<Product> convertToProducts(Map<String, String> map) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        if (map == null) {
            return arrayList;
        }
        for (String string : map.keySet()) {
            Product product = new Product();
            product.setProductCode(string);
            product.setDescription(string);
            arrayList.add(product);
        }
        return arrayList;
    }

    private List<Rating> convertToRatings(Map<String, String> map, Map<String, String> map2) {
        ArrayList<Rating> arrayList = new ArrayList<Rating>();
        if (map == null) {
            return arrayList;
        }
        for (String string : map.keySet()) {
            Rating rating = new Rating();
            rating.setRating(string);
            if (map2 == null || map2.isEmpty()) {
                rating.setRatingSystem("NR");
                arrayList.add(rating);
                continue;
            }
            if (this.isCLRating(rating, map2)) {
                arrayList.add(rating);
                continue;
            }
            if (this.isMSTVRating(rating, map2)) {
                arrayList.add(rating);
                continue;
            }
            Iterator<String> iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                rating = new Rating();
                rating.setRating(string);
                rating.setRatingSystem(iterator.next());
                arrayList.add(rating);
            }
        }
        return arrayList;
    }

    private boolean isCLRating(Rating rating, Map<String, String> map) {
        String string;
        if (this.CL_MPAA_RATINGS.contains(rating.getRating())) {
            if (map != null && map.get("MPAA") != null) {
                rating.setRatingSystem("MPAA");
                return true;
            }
        } else if (this.CL_TV_RATINGS.contains(rating.getRating()) && map != null && map.get("TV") != null) {
            rating.setRatingSystem("TV");
            return true;
        }
        if (this.CL_OTHER_RATINGS.contains(rating.getRating())) {
            if (map != null && map.get("OTHER") != null) {
                rating.setRatingSystem("OTHER");
                return true;
            }
            if (map != null && map.get("Other") != null) {
                rating.setRatingSystem("Other");
                return true;
            }
        }
        if (rating.getRating().indexOf(32) > 0 && this.CL_TV_RATINGS.contains(string = rating.getRating().substring(0, rating.getRating().indexOf(32))) && map != null && map.get("TV") != null) {
            rating.setRatingSystem("TV");
            return true;
        }
        return false;
    }

    private boolean isMSTVRating(Rating rating, Map<String, String> map) {
        if (this.MSTV_ADULTONLY_RATING.contains(rating.getRating()) && map != null && map.get("AdultOnly") != null) {
            rating.setRatingSystem("AdultOnly");
            return true;
        }
        return false;
    }

    private void storeAppType(AppType appType) {
        block7: {
            if (appType == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                AppType appType2 = (AppType)session.get(AppType.class, (Serializable)((Object)appType.getAppType()));
                if (appType2 == null) {
                    appType2 = new AppType();
                    appType2.setAppType(appType.getAppType());
                    appType2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("App Type [" + appType.getAppType() + "] already exists in the system."));
                }
                appType2.setNotes(appType.getNotes());
                session.saveOrUpdate((Object)appType2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private void storeContentAdvisory(ContentAdvisory contentAdvisory) {
        block7: {
            if (contentAdvisory == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                ContentAdvisory contentAdvisory2 = (ContentAdvisory)session.get(ContentAdvisory.class, (Serializable)((Object)contentAdvisory.getContentAdvisory()));
                if (contentAdvisory2 == null) {
                    contentAdvisory2 = new ContentAdvisory();
                    contentAdvisory2.setContentAdvisory(contentAdvisory.getContentAdvisory());
                    contentAdvisory2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("Content Advisory [" + contentAdvisory.getContentAdvisory() + "] already exists in the system."));
                }
                contentAdvisory2.setDescription(contentAdvisory.getDescription());
                session.saveOrUpdate((Object)contentAdvisory2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private void storeGenre(Genre genre) {
        block7: {
            if (genre == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                Genre genre2 = (Genre)session.get(Genre.class, (Serializable)((Object)genre.getGenre()));
                if (genre2 == null) {
                    genre2 = new Genre();
                    genre2.setGenre(genre.getGenre());
                    genre2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("Genre [" + genre.getGenre() + "] already exists in the system."));
                }
                genre2.setDescription(genre.getDescription());
                session.saveOrUpdate((Object)genre2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private void storeProduct(Product product) {
        block7: {
            if (product == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                Product product2 = (Product)session.get(Product.class, (Serializable)((Object)product.getProductCode()));
                if (product2 == null) {
                    product2 = new Product();
                    product2.setProductCode(product.getProductCode());
                    product2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("Product code [" + product.getProductCode() + "] already exists in the system."));
                }
                product2.setDescription(product.getDescription());
                session.saveOrUpdate((Object)product2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private void storeRating(Rating rating) {
        block7: {
            if (rating == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                Query query = session.getNamedQuery(SELECT_RATING);
                query.setParameter("rating", (Object)rating.getRating());
                query.setParameter("ratingSystem", (Object)rating.getRatingSystem());
                Rating rating2 = (Rating)query.uniqueResult();
                if (rating2 == null) {
                    rating2 = new Rating();
                    rating2.setRating(rating.getRating());
                    rating2.setRatingSystem(rating.getRatingSystem());
                    rating2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("Rating [" + rating.getRating() + "] already exists for Rating System [" + rating.getRatingSystem() + "]."));
                }
                rating2.setDescription(rating.getDescription());
                session.saveOrUpdate((Object)rating2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private void storeStudio(Studio studio) {
        block7: {
            if (studio == null) {
                return;
            }
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.getSession();
                transaction = session.beginTransaction();
                Studio studio2 = (Studio)session.get(Studio.class, (Serializable)((Object)studio.getDisplayName()));
                if (studio2 == null) {
                    studio2 = new Studio();
                    studio2.setDisplayName(studio.getDisplayName());
                    studio2.setCreateDate(new Date());
                } else {
                    logger.warn((Object)("Studio [" + studio.getDisplayName() + "] and Organization [" + studio.getOrganizationName() + "] combination already exists in the system."));
                }
                studio2.setOrganizationName(studio.getOrganizationName());
                studio2.setOrganizationCode(studio.getOrganizationCode());
                studio2.setDescription(studio.getDescription());
                session.saveOrUpdate((Object)studio2);
                transaction.commit();
            }
            catch (Throwable throwable) {
                if (transaction == null) break block7;
                try {
                    transaction.rollback();
                }
                catch (Throwable throwable2) {
                    logger.error((Object)"Failed to roll back transaction on exception", throwable2);
                }
            }
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public static Map<String, Map<String, String>> getFieldsWithOptions(UISpecification uISpecification) throws Exception {
        logger.info((Object)"Creating option field map...");
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        logger.info((Object)"Adding options from UI specification (definition.xml)...");
        optionsBuilder.addOptions(uISpecification);
        logger.info((Object)"Adding options from content classes...");
        ContentClassServiceHibernate contentClassServiceHibernate = new ContentClassServiceHibernate();
        HibernateContext.getContext().beginTransaction();
        Map<String, Map<String, String>> map = contentClassServiceHibernate.getFieldsWithOptions();
        HibernateContext.getContext().commitTransaction();
        optionsBuilder.addOptions(map);
        logger.info((Object)"Created option field map");
        return optionsBuilder.getFields();
    }
}

