/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.CustomFieldHandler;
import com.tandbergtv.content.contentclass.PropertyConverter;
import com.tandbergtv.content.contentclass.SpecAttributeHandler;
import com.tandbergtv.content.contentclass.option.OptionsMerger;
import com.tandbergtv.content.contentclass.spec.FlatSpec;
import com.tandbergtv.content.contentclass.spec.FlatSpecBuilder;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderListType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SpecConverter {
    private static TargetVersion targetVersion = TargetVersion.V_31;
    private static Logger logger = Logger.getLogger(SpecConverter.class);
    private String inputFolder;
    private String outputFolder;
    private Specification oldSpec;
    private FlatSpec oldFlatSpec;
    private Specification newSpec;

    public SpecConverter(String string, String string2) {
        this(string, string2, TargetVersion.V_31);
    }

    public SpecConverter(String string, String string2, TargetVersion targetVersion) {
        this.inputFolder = string;
        this.outputFolder = string2;
        SpecConverter.targetVersion = targetVersion;
    }

    public void run(String string, String string2) throws Exception {
        this.run(string, string, string2);
    }

    public void run(String string, String string2, String string3) throws Exception {
        this.newSpec = SpecUtil.loadNewSpecificationTemplate(string);
        File file = new File(this.inputFolder, string2);
        this.oldSpec = SpecUtil.loadSpecification(file.getAbsolutePath());
        FlatSpecBuilder flatSpecBuilder = new FlatSpecBuilder(this.oldSpec);
        this.oldFlatSpec = flatSpecBuilder.build();
        this.mergeAttributes();
        if (targetVersion == TargetVersion.V_25) {
            this.mergeCustomFields();
        }
        this.mergeOptions(string2);
        this.mergeAutoFillProviders();
        this.writeSpec(string2);
        PropertyConverter propertyConverter = new PropertyConverter();
        propertyConverter.setInFileName(string3);
        propertyConverter.setOutFileName(string3);
        propertyConverter.setTemplateFileName(string3);
        propertyConverter.setInFolder(this.inputFolder);
        propertyConverter.setOutFolder(this.outputFolder);
        propertyConverter.process();
    }

    void mergeAttributes() throws Exception {
        logger.info((Object)"Merging attributes...");
        SpecAttributeHandler specAttributeHandler = new SpecAttributeHandler(this.oldFlatSpec, this.newSpec);
        specAttributeHandler.run();
        logger.info((Object)"Finished merging attributes.");
    }

    void mergeOptions(String string) throws Exception {
        logger.info((Object)"Merging field options...");
        File file = new File(this.inputFolder, string);
        UISpecification uISpecification = SpecUtil.loadUISpecification(file.getAbsolutePath());
        OptionsMerger optionsMerger = new OptionsMerger();
        optionsMerger.merge(uISpecification, this.newSpec);
        logger.info((Object)"Finished merging field options.");
    }

    private void writeSpec(String string) throws Exception {
        String string2 = null;
        File file = new File(this.outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        string2 = new File(file, string).getAbsolutePath();
        logger.info((Object)("Writing new spec to " + string2));
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        specificationJaxbService.marshal(this.newSpec, string2);
        logger.info((Object)"Finished writing new spec.");
    }

    private void mergeAutoFillProviders() {
        if (this.oldSpec.getAutofillProviders() == null) {
            return;
        }
        List<AutofillProviderType> list = this.oldSpec.getAutofillProviders().getProvider();
        if (list == null || list.isEmpty()) {
            return;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (this.newSpec.getAutofillProviders() == null) {
            this.newSpec.setAutofillProviders(new AutofillProviderListType());
        }
        List<AutofillProviderType> list2 = this.newSpec.getAutofillProviders().getProvider();
        for (AutofillProviderType object : list2) {
            treeMap.put(object.getName(), object.getJavaClass());
        }
        for (AutofillProviderType autofillProviderType : list) {
            treeMap.put(autofillProviderType.getName(), autofillProviderType.getJavaClass());
        }
        list2.clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            AutofillProviderType autofillProviderType = new AutofillProviderType();
            autofillProviderType.setName((String)entry.getKey());
            autofillProviderType.setJavaClass((String)entry.getValue());
            list2.add(autofillProviderType);
        }
    }

    void mergeCustomFields() {
        logger.info((Object)"Merging custom fields...");
        CustomFieldHandler customFieldHandler = new CustomFieldHandler(this.oldSpec, this.newSpec);
        customFieldHandler.mergeCustomFields();
        logger.info((Object)"Finished merging custom fields.");
    }

    public static enum TargetVersion {
        V_25,
        V_31;

    }
}

