/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;

public class ContentClassHibernateFactory {
    private ContentClassHibernateFactory() {
    }

    public static ContentClass createContentClassWithoutMetadata(ContentClassEntity contentClassEntity) {
        if (contentClassEntity == null) {
            return null;
        }
        ContentClass contentClass = new ContentClass();
        contentClass.setId(contentClassEntity.id);
        switch (contentClassEntity.typeId) {
            case 0: {
                contentClass.setType(ContentClass.Type.Package);
                break;
            }
            case 1: {
                contentClass.setType(ContentClass.Type.Series);
                break;
            }
            case 2: {
                contentClass.setType(ContentClass.Type.Category);
                break;
            }
            default: {
                contentClass.setType(ContentClass.Type.Package);
            }
        }
        contentClass.setName(contentClassEntity.name);
        contentClass.setDescription(contentClassEntity.description);
        contentClass.setDefault(contentClassEntity.isDefault);
        switch (contentClassEntity.specialUsageId) {
            case 1: {
                contentClass.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                break;
            }
            case 2: {
                contentClass.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                break;
            }
            default: {
                contentClass.setSpecialUsage(ContentClass.SpecialUsage.None);
            }
        }
        return contentClass;
    }

    public static ContentClass createContentClass(ContentClassEntity contentClassEntity) throws ContentClassPersistenceException {
        ContentClass contentClass = ContentClassHibernateFactory.createContentClassWithoutMetadata(contentClassEntity);
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        contentClass.setMetadata(contentClassJaxbService.unmarshalContentClassMetadata(contentClassEntity.metadataXml));
        return contentClass;
    }

    public static ContentClassMetadata parseMetadata(String string) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClassMetadata(string);
    }

    public static ContentClassEntity createContentClassHibernate(ContentClass contentClass) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return null;
        }
        ContentClassEntity contentClassEntity = new ContentClassEntity();
        contentClassEntity.id = contentClass.getId();
        contentClassEntity.typeId = contentClass.getType().ordinal();
        contentClassEntity.name = contentClass.getName();
        contentClassEntity.description = contentClass.getDescription();
        contentClassEntity.isDefault = contentClass.isDefault();
        contentClassEntity.specialUsageId = contentClass.getSpecialUsage().ordinal();
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        if (contentClass.getMetadata() != null) {
            contentClassEntity.metadataXml = contentClassJaxbService.marshalContentClassMetadata(contentClass.getMetadata());
        }
        return contentClassEntity;
    }

    public static ContentClassPartner createContentClassPartner(ContentClassPartnerEntity contentClassPartnerEntity) throws ContentClassPersistenceException {
        ContentClassPartner contentClassPartner = new ContentClassPartner();
        contentClassPartner.setContentClassId(contentClassPartnerEntity.getContentClassId());
        contentClassPartner.setPartnerId(contentClassPartnerEntity.getPartnerId());
        if (contentClassPartnerEntity.getMetadataXml() != null) {
            ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
            contentClassPartner.setMetadata(contentClassJaxbService.unmarshalContentClassMetadata(contentClassPartnerEntity.getMetadataXml()));
        }
        return contentClassPartner;
    }

    public static ContentClassPartnerEntity createContentClassPartnerEntity(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        ContentClassPartnerEntity contentClassPartnerEntity = new ContentClassPartnerEntity(contentClassPartner.getContentClassId(), contentClassPartner.getPartnerId());
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        if (contentClassPartner.getMetadata() != null) {
            contentClassPartnerEntity.setMetadataXml(contentClassJaxbService.marshalContentClassMetadata(contentClassPartner.getMetadata()));
        }
        return contentClassPartnerEntity;
    }
}

