/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.jaxb;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.jaxb.model.AssetType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerListType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassPartnerType;
import com.tandbergtv.content.contentclass.jaxb.model.ContentClassType;
import com.tandbergtv.content.contentclass.jaxb.model.DisabledOptionsType;
import com.tandbergtv.content.contentclass.jaxb.model.FieldType;
import com.tandbergtv.content.contentclass.jaxb.model.MetadataType;
import com.tandbergtv.content.contentclass.jaxb.model.OptionType;
import com.tandbergtv.content.contentclass.jaxb.model.OptionsType;
import java.util.Collection;
import java.util.List;

public class ContentClassJaxbFactory {
    public static final String CONTENT_CLASS_VERSION = "2.5";

    public ContentClassType createContentClassType(ContentClass contentClass) {
        ContentClassType contentClassType = new ContentClassType();
        contentClassType.setVersion(CONTENT_CLASS_VERSION);
        contentClassType.setType(contentClass.getType().ordinal());
        contentClassType.setIsDefault(contentClass.isDefault() ? Boolean.valueOf(true) : null);
        contentClassType.setName(contentClass.getName());
        contentClassType.setDescription(contentClass.getDescription());
        contentClassType.setUsage(contentClass.getSpecialUsage().toString());
        contentClassType.setMetadata(this.createMetadataType(contentClass.getMetadata()));
        return contentClassType;
    }

    public ContentClassType createContentClassTypeWithPartners(ContentClass contentClass, List<ContentClassPartner> list) {
        ContentClassType contentClassType = this.createContentClassType(contentClass);
        if (list != null && !list.isEmpty()) {
            contentClassType.setPartners(new ContentClassPartnerListType());
            List<ContentClassPartnerType> list2 = contentClassType.getPartners().getPartner();
            for (ContentClassPartner contentClassPartner : list) {
                ContentClassPartnerType contentClassPartnerType = new ContentClassPartnerType();
                contentClassPartnerType.setName(contentClassPartner.getPartnerName());
                contentClassPartnerType.setMetadata(this.createMetadataType(contentClassPartner.getMetadata()));
                list2.add(contentClassPartnerType);
            }
        }
        return contentClassType;
    }

    public MetadataType createMetadataType(ContentClassMetadata contentClassMetadata) {
        if (contentClassMetadata == null || contentClassMetadata.isEmpty()) {
            return null;
        }
        MetadataType metadataType = new MetadataType();
        metadataType.setVersion(CONTENT_CLASS_VERSION);
        List<AssetType> list = metadataType.getAsset();
        for (ContentClassAsset contentClassAsset : contentClassMetadata.getAssetList()) {
            AssetType assetType = this.createAssetType(contentClassAsset);
            if (assetType == null) continue;
            list.add(assetType);
        }
        return metadataType;
    }

    private AssetType createAssetType(ContentClassAsset contentClassAsset) {
        AssetType assetType = new AssetType();
        assetType.setPath(contentClassAsset.getPath());
        assetType.setIsHidden(contentClassAsset.isDisabled() ? Boolean.valueOf(true) : null);
        assetType.setMin(contentClassAsset.getMin());
        assetType.setMax(contentClassAsset.getMax());
        assetType.setBatchMin(contentClassAsset.getBatchMin());
        assetType.setBatchMax(contentClassAsset.getBatchMax());
        assetType.setHideFileView(contentClassAsset.isHideFileView() ? Boolean.valueOf(true) : null);
        assetType.setRequiresFile(contentClassAsset.isRequiresFile() ? Boolean.valueOf(true) : null);
        List<FieldType> list = assetType.getField();
        Collection<ContentClassField> collection = contentClassAsset.getFieldList();
        if (collection != null) {
            for (ContentClassField contentClassField : collection) {
                FieldType fieldType = this.createFieldType(contentClassField);
                if (fieldType == null) continue;
                list.add(fieldType);
            }
        }
        return assetType;
    }

    private FieldType createFieldType(ContentClassField contentClassField) {
        Object object;
        FieldType fieldType = new FieldType();
        fieldType.setPath(contentClassField.getPath());
        fieldType.setValue(contentClassField.getDefaultValue());
        if (contentClassField.getFieldType() != null) {
            fieldType.setFieldType(contentClassField.getFieldType().toString());
        }
        fieldType.setIsHidden(contentClassField.isDisabled() ? Boolean.valueOf(true) : null);
        fieldType.setIsLocked(contentClassField.isLocked() ? Boolean.valueOf(true) : null);
        fieldType.setIsRequired(contentClassField.isRequired() ? Boolean.valueOf(true) : null);
        fieldType.setIsAttribute(contentClassField.isAttribute() ? Boolean.valueOf(true) : null);
        fieldType.setIncludeInBatch(contentClassField.getIncludeInBatch() ? Boolean.valueOf(true) : null);
        fieldType.setMin(contentClassField.getMin());
        fieldType.setMax(contentClassField.getMax());
        fieldType.setIsAutofillable(contentClassField.isAutofillable() ? Boolean.valueOf(true) : null);
        fieldType.setAutofillProvider(contentClassField.getAutofillProvider());
        fieldType.setDisplayPattern(contentClassField.getDisplayPattern());
        List<ContentClassOption> list = contentClassField.getOptions();
        if (list != null && !list.isEmpty()) {
            object = new OptionsType();
            for (ContentClassOption contentClassOption : list) {
                OptionType optionType = new OptionType();
                optionType.setValue(contentClassOption.getValue());
                optionType.setDisplayName(contentClassOption.getDisplayName());
                ((OptionsType)object).getOption().add(optionType);
            }
            fieldType.setOptions((OptionsType)object);
        }
        if (contentClassField.getDisabledOptionKeys() != null) {
            object = new DisabledOptionsType();
            ((DisabledOptionsType)object).getKey().addAll(contentClassField.getDisabledOptionKeys());
            fieldType.setDisabledOptions((DisabledOptionsType)object);
        }
        return fieldType;
    }

    public ContentClass createContentClass(ContentClassType contentClassType) {
        if (contentClassType == null) {
            return null;
        }
        ContentClass contentClass = new ContentClass();
        contentClass.setVersion(contentClassType.getVersion());
        Integer n = contentClassType.getType();
        if (n == null) {
            contentClass.setType(ContentClass.Type.Package);
        } else if (n == 1) {
            contentClass.setType(ContentClass.Type.Series);
        } else if (n == 2) {
            contentClass.setType(ContentClass.Type.Category);
        } else {
            contentClass.setType(ContentClass.Type.Package);
        }
        contentClass.setDefault(contentClassType.isIsDefault() == null ? false : contentClassType.isIsDefault());
        contentClass.setName(contentClassType.getName());
        contentClass.setDescription(contentClassType.getDescription());
        contentClass.setSpecialUsage(ContentClass.SpecialUsage.valueOf(contentClassType.getUsage()));
        contentClass.setMetadata(this.createContentClassMetadata(contentClassType.getMetadata()));
        return contentClass;
    }

    public ContentClassPartner createContentClassPartner(ContentClassPartnerType contentClassPartnerType) {
        ContentClassPartner contentClassPartner = new ContentClassPartner();
        contentClassPartner.setPartnerName(contentClassPartnerType.getName());
        contentClassPartner.setMetadata(this.createContentClassMetadata(contentClassPartnerType.getMetadata()));
        return contentClassPartner;
    }

    public ContentClassMetadata createContentClassMetadata(MetadataType metadataType) {
        if (metadataType == null) {
            return null;
        }
        ContentClassMetadata contentClassMetadata = new ContentClassMetadata();
        contentClassMetadata.setVersion(metadataType.getVersion());
        List<AssetType> list = metadataType.getAsset();
        if (list != null) {
            for (AssetType assetType : list) {
                ContentClassAsset contentClassAsset = this.createContentClassAsset(assetType);
                if (contentClassAsset == null) continue;
                contentClassMetadata.addAsset(contentClassAsset);
            }
        }
        return contentClassMetadata;
    }

    private ContentClassAsset createContentClassAsset(AssetType assetType) {
        if (assetType == null) {
            return null;
        }
        ContentClassAsset contentClassAsset = new ContentClassAsset(assetType.getPath());
        contentClassAsset.setDisabled(assetType.isIsHidden());
        contentClassAsset.setMin(assetType.getMin());
        contentClassAsset.setMax(assetType.getMax());
        contentClassAsset.setBatchMin(assetType.getBatchMin());
        contentClassAsset.setBatchMax(assetType.getBatchMax());
        contentClassAsset.setHideFileView(assetType.isHideFileView());
        contentClassAsset.setRequiresFile(assetType.isRequiresFile());
        List<FieldType> list = assetType.getField();
        if (list != null) {
            for (FieldType fieldType : list) {
                ContentClassField contentClassField = this.createContentClassField(fieldType);
                if (contentClassField == null) continue;
                contentClassAsset.addField(contentClassField);
            }
        }
        return contentClassAsset;
    }

    private ContentClassField createContentClassField(FieldType fieldType) {
        List<OptionType> list;
        if (fieldType == null) {
            return null;
        }
        ContentClassField contentClassField = new ContentClassField(fieldType.getPath());
        String string = fieldType.getFieldType();
        if (string != null) {
            contentClassField.setFieldType(ContentClassField.FieldType.valueOf(string));
        }
        contentClassField.setDefaultValue(fieldType.getValue());
        contentClassField.setDisabled(fieldType.isIsHidden());
        contentClassField.setLocked(fieldType.isIsLocked());
        contentClassField.setRequired(fieldType.isIsRequired());
        contentClassField.setAttribute(fieldType.isIsAttribute());
        contentClassField.setMin(fieldType.getMin());
        contentClassField.setMax(fieldType.getMax());
        contentClassField.setIncludeInBatch(fieldType.isIncludeInBatch());
        contentClassField.setAutofillable(fieldType.isIsAutofillable());
        contentClassField.setAutofillProvider(fieldType.getAutofillProvider());
        contentClassField.setDisplayPattern(fieldType.getDisplayPattern());
        if (fieldType.getOptions() != null && (list = fieldType.getOptions().getOption()) != null && !list.isEmpty()) {
            for (OptionType optionType : list) {
                ContentClassOption contentClassOption = new ContentClassOption(optionType.getValue(), optionType.getDisplayName());
                contentClassField.addOption(contentClassOption);
            }
        }
        if (fieldType.getDisabledOptions() != null) {
            contentClassField.addDisabledOptionKeys(fieldType.getDisabledOptions().getKey());
        }
        return contentClassField;
    }
}

