/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class UISpecification {
    private Type type;
    private TitleConf rootTitleConf;
    private ClassLoader classLoader;
    private ResourceBundle bundle;
    private String tableConfigurationPath;
    private List<AutofillProvider> autofillProviders = new ArrayList<AutofillProvider>(1);

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public TitleConf getRootTitleConf() {
        return this.rootTitleConf;
    }

    public void setRootTitleConf(TitleConf titleConf) {
        this.rootTitleConf = titleConf;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getTableConfigurationPath() {
        return this.tableConfigurationPath;
    }

    public void setTableConfigurationPath(String string) {
        this.tableConfigurationPath = string;
    }

    public List<AutofillProvider> getAutofillProviders() {
        if (this.bundle != null) {
            for (AutofillProvider autofillProvider : this.autofillProviders) {
                String string;
                try {
                    string = this.bundle.getString(autofillProvider.getName());
                }
                catch (Exception exception) {
                    string = autofillProvider.getName();
                }
                autofillProvider.setDisplayName(string);
            }
        }
        return this.autofillProviders;
    }

    public void addAutofillProvider(AutofillProvider autofillProvider) {
        this.autofillProviders.add(autofillProvider);
    }

    public List<TitleConf> getAllTitleConf() {
        ArrayList<TitleConf> arrayList = new ArrayList<TitleConf>();
        arrayList.add(this.rootTitleConf);
        arrayList.addAll(this.rootTitleConf.getAllDescendants());
        return arrayList;
    }

    public InputStream getTableExtensionConfiguration() {
        return this.classLoader.getResourceAsStream(this.tableConfigurationPath);
    }

    public static enum Type {
        PACKAGE,
        SERIES;

    }
}

