/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.AssetDB;
import com.ericsson.metadatamanager.util.AssetReader;
import com.ericsson.metadatamanager.util.DocumentLoader;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Relation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class AssetConverter {
    AssetDB db = new AssetDB();
    private static final Logger logger = Logger.getLogger(AssetConverter.class);

    public Connection getConnection() {
        return this.db.getConnection();
    }

    public void closeConnection(Connection conn) {
        this.db.closeConnection(conn);
    }

    private Long getRootAssetId(Connection conn, long titleId) {
        String sql = "select mdmdocid from pmm_title where id_=" + titleId;
        Long docId = null;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            while (rset.next()) {
                docId = rset.getLong(1);
            }
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return docId;
    }

    private void dumpAssetTree(Asset asset) {
        if (asset == null) {
            return;
        }
        System.out.println(asset.toString());
        for (Relation r : asset.getRelations()) {
            this.dumpAssetTree(r.getTargetAsset());
        }
    }

    public void dumpAssetModelAndDocument(Connection conn, long rootAssetId) {
        AssetReader ar = new AssetReader();
        ar.setConnection(conn);
        int revision = 2000000000;
        Asset assetModel = ar.getAssetModel(rootAssetId, revision, true);
        this.dumpAssetTree(assetModel);
        DocumentLoader docLoader = new DocumentLoader();
        boolean checkInvalidXpaths = true;
        System.out.println(docLoader.convertToXml(assetModel, checkInvalidXpaths));
    }

    public void dumpMetadataStatus(Connection conn) {
        String sql = "select id_,mdmdocid from pmm_title where mdmdocid in";
        sql = sql + " (select mdmdocid from pmm_title where titlestatusid <> 5";
        sql = sql + " minus";
        sql = sql + " select extractvalue(sys_nc_rowinfo$, 'ECMFSpec/@documentId') from mdm_metadata)";
        sql = sql + " order by id_ asc";
        try {
            System.out.println("Querying for active titles with missing data in mdm_metadata.");
            System.out.println("Please wait.");
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            Long titleId = null;
            Long docId = null;
            boolean isEmpty = true;
            logger.info("");
            logger.info("Metadata missing for the following titles:");
            logger.info("Title ID,  Document ID");
            logger.info("--------,  ----------");
            while (rset.next()) {
                isEmpty = false;
                titleId = rset.getLong(1);
                docId = rset.getLong(2);
                logger.info(titleId + ",     " + docId);
            }
            stmt.close();
            logger.info("");
            if (isEmpty) {
                System.out.println("Query completed with no missing data.");
            } else {
                System.out.println("Query completed. Please check log file for details.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        Long rootAssetId;
        if (args.length < 1) {
            System.out.println("Usage:com.ericsson.metadatamanager.util.AssetConverter status or <documentId>");
            return;
        }
        AssetConverter ac = new AssetConverter();
        String arg1 = args[0].trim();
        if (arg1.equalsIgnoreCase("status")) {
            Connection conn = ac.getConnection();
            ac.dumpMetadataStatus(conn);
            ac.closeConnection(conn);
            return;
        }
        Long id = Long.parseLong(args[0].trim());
        Integer type = 0;
        if (args.length > 1) {
            type = Integer.parseInt(args[1].trim());
        }
        Connection conn = ac.getConnection();
        if (type == 1) {
            rootAssetId = ac.getRootAssetId(conn, id);
            if (rootAssetId == null) {
                System.out.println("Error: No root asset id found for title id " + id);
                return;
            }
        } else {
            rootAssetId = id;
        }
        ac.dumpAssetModelAndDocument(conn, rootAssetId);
        ac.closeConnection(conn);
    }
}

