/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.util;

import com.ericsson.metadatamanager.util.Loader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleDriver;
import org.apache.log4j.Logger;

public class Table {
    private static final Logger logger = Logger.getLogger(Loader.class);

    private boolean runScript(Connection conn, String sql) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall(sql);
            logger.info(" executing:" + sql);
            res = cs.execute();
            cs.close();
            logger.info(" complete executing:" + sql);
            res = true;
        }
        catch (SQLException e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean unRegisterMetadataStructIndex(Connection conn) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall("BEGIN dbms_xmlindex.dropparameter(?); END;");
            cs.setString(1, "ecmfstructuredxml_idx");
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean registerMetadataStructIndex(Connection conn) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall("BEGIN dbms_xmlindex.registerparameter(?,?); END;");
            cs.setString(1, "ecmfstructuredxml_idx");
            String parm = "'ADD_GROUP GROUP ecmfdisplayfields";
            parm = parm + " XMLTable ecmfdisplay_tab ''/ECMFSpec''";
            parm = parm + " COLUMNS ttvid number path ''@documentId'',";
            parm = parm + "PackageAssetId varchar2(1000) path ''Package/Fields/Identifier/Id'',";
            parm = parm + "titlebrief varchar2(1000) path ''Package/Title/Fields/Title/ShortTitle/Value'',";
            parm = parm + "versionmajor number path ''Package/Fields/Version/Major'',";
            parm = parm + "licwinstrt timestamp path ''Package/Title/Fields/Rights/LicensingWindowStart'',";
            parm = parm + "licwinend timestamp path ''Package/Title/Fields/Rights/LicensingWindowEnd'',";
            parm = parm + "Assetname varchar2(1000) path ''Package/Fields/AssetName''";
            parm = parm + "'";
            cs.setString(2, parm);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean updateBitRateXpathForField(Connection conn) {
        boolean res = false;
        try {
            String sql = "update";
            sql = sql + "(select f.ttvxpath,  f.indices from mdm_field f inner join mdm_asset a on f.asset_id = a.id ";
            sql = sql + "where a.type='FILE' and f.ttvxpath ='/tns:Fields/tns:Video/tns:BitRate/tns:Value') t ";
            sql = sql + "set t.ttvxpath ='/tns:Fields/tns:Video/tns:BitRate/@value', t.indices='#1#1#1'";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean updateBitRateXpathForFieldRevision(Connection conn) {
        boolean res = false;
        try {
            String sql = "update";
            sql = sql + "(select f.ttvxpath,  f.indices from mdm_fieldrevision f inner join mdm_asset a on f.asset_id = a.id ";
            sql = sql + "where a.type='FILE' and f.ttvxpath ='/tns:Fields/tns:Video/tns:BitRate/tns:Value') t ";
            sql = sql + "set t.ttvxpath ='/tns:Fields/tns:Video/tns:BitRate/@value', t.indices='#1#1#1'";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean deleteProviderInfoXpathForFileInField(Connection conn) {
        boolean res = false;
        try {
            String sql = "delete";
            sql = sql + "(select f.id, f.asset_id, f.ttvxpath ";
            sql = sql + "from mdm_field f inner join mdm_asset a ";
            sql = sql + "on f.asset_id = a.id ";
            sql = sql + "where a.type='FILE' and f.ttvxpath like'/tns:Fields/tns:ProviderInfo%')";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean deleteProviderInfoXpathForFileInFieldRevision(Connection conn) {
        boolean res = false;
        try {
            String sql = "delete";
            sql = sql + "(select f.id, f.asset_id, f.ttvxpath ";
            sql = sql + "from mdm_fieldrevision f inner join mdm_asset a ";
            sql = sql + "on f.asset_id = a.id ";
            sql = sql + "where a.type='FILE' and f.ttvxpath like'/tns:Fields/tns:ProviderInfo%')";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean deleteFieldWithSpecificXpath(Connection conn, String assetType, String xpath) {
        boolean res = false;
        try {
            String sql = "delete";
            sql = sql + "(select f.id, f.asset_id, f.ttvxpath ";
            sql = sql + "from mdm_field f inner join mdm_asset a ";
            sql = sql + "on f.asset_id = a.id ";
            sql = sql + "where a.type='" + assetType;
            sql = sql + "' and f.ttvxpath like '";
            sql = sql + xpath + "'";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean deleteFieldRevisionWithSpecificXpath(Connection conn, String assetType, String xpath) {
        boolean res = false;
        try {
            String sql = "delete";
            sql = sql + "(select f.id, f.asset_id, f.ttvxpath ";
            sql = sql + "from mdm_fieldrevision f inner join mdm_asset a ";
            sql = sql + "on f.asset_id = a.id ";
            sql = sql + "where a.type='" + assetType;
            sql = sql + "' and f.ttvxpath like '";
            sql = sql + xpath + "'";
            CallableStatement cs = conn.prepareCall(sql);
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean recreateMdmIndices(Connection conn) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall("BEGIN SYS.createWFSDB.RECREATE_XML_INDEXES; END;");
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return res;
    }

    private boolean execCallToDropMdmIndices(Connection conn) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall("BEGIN sys.createwfsdb.DROP_XML_INDEXES; END;");
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            res = false;
        }
        return res;
    }

    private void dropMdmIndices(Connection conn) {
        String sql = "DROP INDEX wfs.mdm_index_xmltype force";
        logger.info(" Dropping index wfs.mdm_index_xmltype....");
        boolean res = this.runScript(conn, sql);
        if (res) {
            logger.info("wfs.mdm_index_xmltype index dropped");
        }
        sql = "DROP INDEX wfs.ecmfspec_xmlindex force";
        logger.info(" Dropping index wfs.ecmfspec_xmlindex....");
        res = this.runScript(conn, sql);
        if (res) {
            logger.info("wfs.ecmfspec_xmlindex dropped");
        }
        sql = "DROP INDEX wfs.ecmfspec_rev_xmlindex force";
        logger.info(" Dropping index wfs.ecmfspec_rev_xmlindex....");
        res = this.runScript(conn, sql);
        if (res) {
            logger.info("wfs.ecmfspec_rev_xmlindex index dropped");
        }
        sql = "DROP INDEX wfs.idx_xml_path_tab force";
        logger.info(" Dropping index wfs.idx_xml_path_tab....");
        res = this.runScript(conn, sql);
        if (res) {
            logger.info("index wfs.idx_xml_path_tab index dropped");
        }
        sql = "DROP INDEX wfs.idx_ecmfdisplaytab_ttvid force";
        logger.info(" Dropping index wfs.idx_ecmfdisplaytab_ttvid....");
        res = this.runScript(conn, sql);
        if (res) {
            logger.info("wfs.idx_ecmfdisplaytab_ttvid index dropped");
        }
        this.dropXmlIndexParameters(conn);
    }

    private boolean dropXmlIndexParameters(Connection conn) {
        boolean res = false;
        try {
            CallableStatement cs = conn.prepareCall("BEGIN dbms_xmlindex.dropparameter('ecmfstructuredxml_idx'); END;");
            res = cs.execute();
            cs.close();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            res = false;
        }
        return res;
    }

    public void updateDatabaseBeforeMigration(Connection conn) {
        this.dropMdmIndices(conn);
        logger.info(" Updating BitRate Xpath For Field table....");
        this.updateBitRateXpathForField(conn);
        logger.info(" Updating BitRate Xpath For FieldRevision table....");
        this.updateBitRateXpathForFieldRevision(conn);
        logger.info(" Deleting File Xpaths with ProviderInfo for Field table....");
        this.deleteProviderInfoXpathForFileInField(conn);
        logger.info(" Deleting File Xpaths with ProviderInfo for FieldRevision table....");
        this.deleteProviderInfoXpathForFileInFieldRevision(conn);
    }

    public void updateMdmDocId(Connection conn) {
        String sql = "update pmm_title set mdmdocid=asset_id";
        logger.info(" updating pmm_title....");
        boolean res = this.runScript(conn, sql);
        if (res) {
            logger.info("mdmdocid in pmm_title updated");
        }
    }

    public void updateDatabaseAfterMigration(Connection conn) {
        logger.info(" Recreating mdm_metadata/revision indices....");
        boolean res = this.recreateMdmIndices(conn);
        if (res) {
            logger.info("indices for mdm_metadata/revision  created");
        }
    }

    public long getCountMdmMetadata(Connection conn) {
        String sql = "select count(*) from mdm_metadata";
        Long count = 0L;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rset = stmt.executeQuery();
            if (rset.next()) {
                count = rset.getLong(1);
            }
            stmt.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
        return count;
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:oracle:thin:@10.116.49.174:1521:ttv";
        String user = "wfs";
        String pwd = "Wf$1234";
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection conn = DriverManager.getConnection(url, user, pwd);
        Table test = new Table();
        boolean res = test.recreateMdmIndices(conn);
        conn.close();
        System.out.println(" Done....");
    }
}

