/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms;

import com.ericsson.cms.PartnerManager;
import com.ericsson.cms.Scheduler;
import com.ericsson.cms.SiteManager;
import com.ericsson.cms.Util;
import com.ericsson.cms.hibernate.HibernateUtil;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class CHT {
    private static final Logger logger = Logger.getLogger(CHT.class);

    public static void main(String[] stringArray) {
        try {
            CHT.upgrade();
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgrade() {
        Date date = new Date();
        logger.info((Object)("Upgrade started at: " + date));
        Date date2 = CHT.getBeginningOfTomorrow(date);
        logger.info((Object)("All pitch schedules with pitch date before " + date2 + " will be ignored from scheduling"));
        File file = new File("../resources/cht_merge.info");
        if (!file.exists()) {
            throw new RuntimeException("Configuration file does not exist: " + file);
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while reading properties from file: " + file, exception);
        }
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        int n = -1;
        int n2 = -1;
        try {
            l = Long.parseLong(properties.getProperty("northPartnerId"));
            l2 = Long.parseLong(properties.getProperty("southPartnerId"));
            l3 = Long.parseLong(properties.getProperty("bothPartnerId"));
            n = Integer.parseInt(properties.getProperty("northSiteId"));
            n2 = Integer.parseInt(properties.getProperty("southSiteId"));
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while parsing merge information", exception);
        }
        try {
            CHT.getSession().beginTransaction();
            Scheduler.start();
            if (Util.hasFinishRecord()) {
                logger.info((Object)"Finish record found. Aborting.");
                return;
            }
            Partner partner = CHT.getDistPartner(l);
            Partner partner2 = CHT.getDistPartner(l2);
            Partner partner3 = CHT.getDistPartner(l3);
            DistributionSite distributionSite = CHT.getDistSite(n);
            DistributionSite distributionSite2 = CHT.getDistSite(n2);
            logger.info((Object)"Cleaning up quartz jobs");
            Scheduler.cleanupQuartz();
            logger.info((Object)("Upgrading north distribution partner: " + partner.getId() + " | " + partner.getName()));
            Scheduler.deleteSchedulesOfDistPartner(partner.getId());
            CHT.merge(partner, n);
            CHT.scheduleFuturePitchSchedules(partner.getContainerContextId(), date2);
            logger.info((Object)("Upgrading south distribution partner: " + partner2.getId() + " | " + partner2.getName()));
            Scheduler.deleteSchedulesOfDistPartner(partner2.getId());
            CHT.merge(partner2, n2);
            CHT.scheduleFuturePitchSchedules(partner2.getContainerContextId(), date2);
            logger.info((Object)("Upgrading both distribution partner: " + partner3.getId() + " | " + partner3.getName()));
            Scheduler.deleteSchedulesOfDistPartner(partner3.getId());
            CHT.upgradeToNewLogicalSite(partner3.getId(), distributionSite, distributionSite2);
            CHT.scheduleFuturePitchSchedules(partner3.getContainerContextId(), date2);
            Util.addFinishRecord();
            CHT.getSession().getTransaction().commit();
        }
        finally {
            Scheduler.stop();
        }
        logger.info((Object)("Finished upgrading at: " + new Date()));
    }

    private static Partner getDistPartner(long l) {
        Partner partner = PartnerManager.getDistPartner(l);
        if (partner == null) {
            throw new RuntimeException("No distribution partner can be found for id: " + l);
        }
        return partner;
    }

    private static DistributionSite getDistSite(int n) {
        DistributionSite distributionSite = SiteManager.getDistSite(n);
        if (distributionSite == null) {
            throw new RuntimeException("No distribution site can be found for id: " + n);
        }
        return distributionSite;
    }

    private static void merge(Partner partner, int n) {
        DistributionSite distributionSite = SiteManager.inactivateDistSite(n);
        partner.setName("SITE_" + n);
        CHT.save(partner);
        logger.info((Object)("Merged with existing site: [" + distributionSite + "]"));
    }

    private static void upgradeToNewLogicalSite(long l, DistributionSite ... distributionSiteArray) {
        Partner partner = PartnerManager.getDistPartner(l);
        LogicalSite logicalSite = new LogicalSite();
        String string = SiteManager.findNonExistingSiteName(partner.getName());
        logicalSite.setName(string);
        for (DistributionSite distributionSite : distributionSiteArray) {
            logicalSite.addChild(distributionSite);
        }
        CHT.getSession().save((Object)logicalSite);
        partner.setName("SITE_" + logicalSite.getId());
        CHT.save(partner);
        logger.info((Object)("Merged with a new site: [" + logicalSite + "]"));
    }

    private static void scheduleFuturePitchSchedules(long l, Date date) {
        List<DistributionSchedule> list = PartnerManager.getSchedules(l);
        logger.info((Object)("There are " + list.size() + " pitch schedules for this partner"));
        for (DistributionSchedule distributionSchedule : list) {
            if (distributionSchedule.getPitchDate().before(date)) {
                logger.info((Object)("Ignored scheduling a job for pitch schedule: " + distributionSchedule.getId() + ". Reason: Pitch Time [" + distributionSchedule.getPitchDate() + "] is before tomorrow"));
                continue;
            }
            Scheduler.schedule(distributionSchedule.getId(), distributionSchedule.getPitchDate());
        }
    }

    private static void save(Object object) {
        CHT.getSession().save(object);
    }

    private static Date getBeginningOfTomorrow(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static Session getSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }
}

