/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms;

import com.ericsson.cms.hibernate.HibernateUtil;
import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.ericsson.cms.scheduler.entities.WOJob;
import com.ericsson.cms.scheduler.quartz.QuartzScheduler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class Scheduler {
    private static final Logger logger = Logger.getLogger(Scheduler.class);
    private static final String DIST_PARTNER_ENTITY_TYPE = "DISTRIBUTION";
    private static final String DIST_SCHEDULE_ENTITY_TYPE = "DistributionSchedule";
    private static QuartzScheduler quartz = new QuartzScheduler();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat timeFormat;

    public static void start() {
        quartz.start();
    }

    public static void schedule(long l, Date date) {
        Job job = new Job();
        job.setName("Job for Distribution Schedule: " + l);
        job.setActive(true);
        job.setAssociatedEntityType(DIST_SCHEDULE_ENTITY_TYPE);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(l);
        job.setAssociatedEntities(hashSet);
        job.setAssociationDescription("Distribution Schedule: " + l);
        job.setRule(Scheduler.getRule(date));
        job.setCallbackClass("com.tandbergtv.watchpoint.pmm.schedule.DistScheduleSchedulerCallback");
        Scheduler.getSession().save((Object)job);
        quartz.schedule(job.getId(), new ScheduleTime(date));
        logger.info((Object)("Created a new job: " + job + " scheduled to run at: " + date));
    }

    private static ScheduleRule getRule(Date date) {
        ScheduleRule scheduleRule = new ScheduleRule();
        scheduleRule.setType(ScheduleRuleType.ON_DATE);
        ArrayList<ScheduleRuleParameter> arrayList = new ArrayList<ScheduleRuleParameter>(2);
        ScheduleRuleParameter scheduleRuleParameter = new ScheduleRuleParameter();
        scheduleRuleParameter.setValue(dateFormat.format(date));
        scheduleRuleParameter.setOrder(1);
        arrayList.add(scheduleRuleParameter);
        ScheduleRuleParameter scheduleRuleParameter2 = new ScheduleRuleParameter();
        scheduleRuleParameter2.setValue(timeFormat.format(date));
        scheduleRuleParameter2.setOrder(2);
        arrayList.add(scheduleRuleParameter2);
        scheduleRule.setParams(arrayList);
        scheduleRule.setStartDate(date);
        scheduleRule.setEndDate(date);
        return scheduleRule;
    }

    public static void deleteSchedulesOfDistPartner(long l) {
        List<Job> list = Scheduler.getJobsOfAssociatedEntity(DIST_PARTNER_ENTITY_TYPE, l);
        if (list == null || list.isEmpty()) {
            logger.info((Object)("No jobs found for distribution partner: " + l));
        } else {
            for (Job job : list) {
                Scheduler.deleteJob(job);
            }
        }
    }

    public static List<Job> getJobsOfAssociatedEntity(String string, long l) {
        String string2 = "from Job where associatedEntityType = :entityType and :entityId in elements(associatedEntities)";
        Session session = Scheduler.getSession();
        Query query = session.createQuery(string2);
        query.setParameter("entityType", (Object)string);
        query.setParameter("entityId", (Object)l);
        List list = query.list();
        return list == null ? new ArrayList(0) : list;
    }

    public static void deleteJob(Job job) {
        Scheduler.deleteWOJobForJobId(job.getId());
        Scheduler.deletePastExecutions(job.getId());
        quartz.deleteSchedule(job.getId());
        Scheduler.getSession().delete((Object)job);
        logger.info((Object)("Deleted job: " + job));
    }

    private static void deleteWOJobForJobId(long l) {
        WOJob wOJob = Scheduler.getWOJobForJobId(l);
        if (wOJob != null) {
            Scheduler.getSession().delete((Object)wOJob);
        }
    }

    private static WOJob getWOJobForJobId(long l) {
        String string = "from WOJob where jobId = :jobId";
        Query query = Scheduler.getSession().createQuery(string);
        query.setParameter("jobId", (Object)l);
        return (WOJob)query.uniqueResult();
    }

    private static Job getJob(long l) {
        String string = "from Job where id = :jobId";
        Query query = Scheduler.getSession().createQuery(string);
        query.setParameter("jobId", (Object)l);
        return (Job)query.uniqueResult();
    }

    private static void deletePastExecutions(long l) {
        String string = "delete from PastExecution where job.id = :jobId";
        Session session = Scheduler.getSession();
        Query query = session.createQuery(string);
        query.setLong("jobId", l);
        int n = query.executeUpdate();
        logger.info((Object)("Deleted " + n + " past execution records for job: " + l));
    }

    public static void inactivate(long l) {
        Job job = Scheduler.getJob(l);
        job.setActive(false);
        Scheduler.getSession().save((Object)job);
    }

    public static void cleanupQuartz() {
        String[] stringArray = quartz.getAllJobs();
        if (stringArray == null || stringArray.length == 0) {
            logger.info((Object)"No quartz jobs found.");
            return;
        }
        boolean bl = false;
        for (String string : stringArray) {
            long l;
            if (string == null) {
                logger.error((Object)"Found a quartz job with name as null. Ignoring this quartz job.");
                continue;
            }
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)("Found a quartz job with name: [" + string + "] which is not a long value. Ignoring this quartz job."));
                continue;
            }
            Job job = Scheduler.getJob(l);
            if (job != null) continue;
            bl = true;
            logger.info((Object)("Quartz job [Name: " + string + " | " + quartz.getJobInfo(string) + "] does not have a Scheduler job. Hence removing it."));
            quartz.deleteSchedule(l);
        }
        if (!bl) {
            logger.info((Object)"No quartz job that does not have a scheduler job is found.");
        }
    }

    public static void stop() {
        quartz.stop();
    }

    private static Session getSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }

    static {
        dateFormat.setLenient(false);
        timeFormat = new SimpleDateFormat("h:mm a");
        timeFormat.setLenient(false);
    }
}

